/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.hammer.view;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.hammer.validation.issues.IIssue;
import com.archimatetool.hammer.validation.issues.IIssueCategory;
import com.archimatetool.hammer.view.Messages;
import java.text.Collator;
import java.util.List;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class ValidatorViewer
extends TreeViewer {
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    private String[] columnNames = new String[]{Messages.ValidatorViewer_0, Messages.ValidatorViewer_1, Messages.ValidatorViewer_2};
    private int[] columnWeights = new int[]{20, 60, 20};
    private int[] columnSort = new int[]{DESCENDING, DESCENDING, DESCENDING};

    public ValidatorViewer(Composite parent, int style) {
        super(parent, style | 2 | 0x10000);
        this.setContentProvider((IContentProvider)new ValidatorViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ValidatorViewerLabelProvider());
        this.getTree().setHeaderVisible(true);
        this.getTree().setLinesVisible(true);
        this.setUseHashlookup(true);
        TreeColumnLayout layout = (TreeColumnLayout)this.getControl().getParent().getLayout();
        int i = 0;
        while (i < this.columnNames.length) {
            final TreeColumn column = new TreeColumn(this.getTree(), 0);
            column.setText(this.columnNames[i]);
            column.setData((Object)i);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(this.columnWeights[i], true));
            column.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int index;
                    int n = index = ((Integer)column.getData()).intValue();
                    ValidatorViewer.this.columnSort[n] = ValidatorViewer.this.columnSort[n] * -1;
                    ValidatorViewer.this.setColumnSorting(column, ValidatorViewer.this.columnSort[index]);
                    ValidatorViewer.this.sort(index);
                }
            });
            ++i;
        }
    }

    private void setColumnSorting(TreeColumn column, int order) {
        this.getTree().setSortColumn(column);
        this.getTree().setSortDirection(order == ASCENDING ? 128 : 1024);
    }

    private void sort(final int columnIndex) {
        this.setComparator(new ViewerComparator(Collator.getInstance()){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IIssueCategory && e2 instanceof IIssueCategory) {
                    return 0;
                }
                ITableLabelProvider provider = (ITableLabelProvider)ValidatorViewer.this.getLabelProvider();
                String s1 = provider.getColumnText(e1, columnIndex);
                String s2 = provider.getColumnText(e2, columnIndex);
                if (s1 == null) {
                    s1 = "";
                }
                if (s2 == null) {
                    s2 = "";
                }
                return ValidatorViewer.this.columnSort[columnIndex] == ASCENDING ? this.getComparator().compare(s1, s2) : this.getComparator().compare(s2, s1);
            }
        });
    }

    class ValidatorViewerContentProvider
    implements ITreeContentProvider {
        ValidatorViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IIssueCategory) {
                return ((IIssueCategory)parentElement).getIssues().toArray();
            }
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class ValidatorViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ValidatorViewerLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IIssueCategory) {
                if (columnIndex == 0) {
                    IIssueCategory category = (IIssueCategory)element;
                    int size = category.getIssues().size();
                    String text = size == 1 ? Messages.ValidatorViewer_3 : Messages.ValidatorViewer_4;
                    return category.getName() + " (" + size + " " + text + ")";
                }
                return "";
            }
            if (element instanceof IIssue) {
                IIssue issue = (IIssue)element;
                switch (columnIndex) {
                    case 0: {
                        return issue.getName();
                    }
                    case 1: {
                        return issue.getDescription();
                    }
                    case 2: {
                        return ArchiLabelProvider.INSTANCE.getLabel(issue.getObject());
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IIssue) {
                    return ((IIssue)element).getImage();
                }
                if (element instanceof IIssueCategory) {
                    return ((IIssueCategory)element).getImage();
                }
            }
            return null;
        }
    }
}

