/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.export.svg;

import com.archimatetool.editor.diagram.IImageExportProvider;
import com.archimatetool.export.svg.AbstractExportProvider;
import com.archimatetool.export.svg.ExportSVGPlugin;
import com.archimatetool.export.svg.IPreferenceConstants;
import com.archimatetool.export.svg.Messages;
import com.archimatetool.model.IDiagramModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFTranscoder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Element;

public class PDFExportProvider
extends AbstractExportProvider
implements IPreferenceConstants {
    public static final String PDF_IMAGE_EXPORT_PROVIDER = "com.archimatetool.export.pdf.imageExporter";
    Button fTextAsShapesButton;
    Button fEmbedFontsButton;
    Button fTextOffsetWorkaroundButton;

    public void export(String providerID, File file) throws Exception {
        this.setDrawTextAsShapes(this.fTextAsShapesButton.getSelection());
        this.setEmbedFonts(this.fEmbedFontsButton.getSelection());
        this.setTextOffsetWorkaround(this.fTextOffsetWorkaroundButton.getSelection());
        this.initialiseGraphics();
        Element root = this.svgGraphics2D.getRoot();
        this.setViewBoxAttribute(root, 0, 0, this.viewPortBounds.width, this.viewPortBounds.height);
        this.writeElementToFile(root, file);
        this.savePreferences();
    }

    public void export(IDiagramModel diagramModel, File file) throws Exception {
        Element root = this.createElementForView(diagramModel, true);
        this.writeElementToFile(root, file);
    }

    private void writeElementToFile(Element root, File file) throws Exception {
        String svgString;
        Object var6_7;
        Throwable throwable;
        PDFTranscoder transcoder = new PDFTranscoder();
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(this.viewPortBounds.width));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)Float.valueOf(this.viewPortBounds.height));
        try {
            throwable = null;
            var6_7 = null;
            try (StringWriter out = new StringWriter();){
                this.svgGraphics2D.stream(root, (Writer)out);
                svgString = out.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.svgGraphics2D.dispose();
        }
        throwable = null;
        var6_7 = null;
        try (FileOutputStream outStream = new FileOutputStream(file);){
            TranscoderOutput outputPDF = new TranscoderOutput((OutputStream)outStream);
            Throwable throwable3 = null;
            Object var10_16 = null;
            try (ByteArrayInputStream svgStringStream = new ByteArrayInputStream(svgString.getBytes("UTF-8"));){
                TranscoderInput inputSVG = new TranscoderInput((InputStream)svgStringStream);
                transcoder.transcode(inputSVG, outputPDF);
                outStream.flush();
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    public void init(IImageExportProvider.IExportDialogAdapter adapter, Composite container, IFigure figure) {
        this.setFigure(figure);
        container.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.create((int)768).applyTo((Control)container);
        this.fTextAsShapesButton = new Button(container, 32);
        this.fTextAsShapesButton.setText(Messages.PDFExportProvider_0);
        GridDataFactory.create((int)768).applyTo((Control)this.fTextAsShapesButton);
        this.fEmbedFontsButton = new Button(container, 32);
        this.fEmbedFontsButton.setText(Messages.PDFExportProvider_1);
        GridDataFactory.create((int)768).applyTo((Control)this.fEmbedFontsButton);
        this.fTextOffsetWorkaroundButton = new Button(container, 32);
        this.fTextOffsetWorkaroundButton.setText(Messages.PDFExportProvider_2);
        GridDataFactory.create((int)768).applyTo((Control)this.fTextOffsetWorkaroundButton);
        this.loadPreferences();
    }

    protected void loadPreferences() {
        IPreferenceStore store = ExportSVGPlugin.getInstance().getPreferenceStore();
        this.fTextAsShapesButton.setSelection(store.getBoolean("pdfTextAsShapes"));
        this.fEmbedFontsButton.setSelection(store.getBoolean("pdfEmbedFonts"));
        this.fTextOffsetWorkaroundButton.setSelection(store.getBoolean("pdfTextOffset"));
    }

    protected void savePreferences() {
        IPreferenceStore store = ExportSVGPlugin.getInstance().getPreferenceStore();
        store.setValue("pdfTextAsShapes", this.fTextAsShapesButton.getSelection());
        store.setValue("pdfEmbedFonts", this.fEmbedFontsButton.getSelection());
        store.setValue("pdfTextOffset", this.fTextOffsetWorkaroundButton.getSelection());
    }
}

