/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.help.cheatsheets;

import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.help.cheatsheets.Messages;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class CreateMapViewCheatSheetAction
extends Action
implements ICheatSheetAction {
    public void run(String[] params, ICheatSheetManager manager) {
        IViewPart viewPart = ViewManager.showViewPart((String)"com.archimatetool.editor.treeModelView", (boolean)true);
        if (viewPart == null) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CreateMapViewCheatSheetAction_0, (String)Messages.CreateMapViewCheatSheetAction_1);
            return;
        }
        IArchimateModel model = (IArchimateModel)viewPart.getAdapter(IArchimateModel.class);
        if (model == null) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CreateMapViewCheatSheetAction_2, (String)Messages.CreateMapViewCheatSheetAction_3);
            return;
        }
        EList diagramModels = model.getDiagramModels();
        if (diagramModels.size() < 2) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.CreateMapViewCheatSheetAction_4, (String)Messages.CreateMapViewCheatSheetAction_5);
            return;
        }
        CommandStack stack = (CommandStack)model.getAdapter(CommandStack.class);
        if (stack != null) {
            stack.execute((Command)new NewMapViewCommand(model));
        }
    }

    static class NewMapViewCommand
    extends Command {
        IArchimateModel model;
        IFolder parentFolder;
        IDiagramModel diagramModel;

        NewMapViewCommand(IArchimateModel model) {
            super(Messages.CreateMapViewCheatSheetAction_7);
            this.model = model;
        }

        public void execute() {
            this.createMapView(this.model);
            EditorManager.openDiagramEditor((IDiagramModel)this.diagramModel);
        }

        public void undo() {
            EditorManager.closeDiagramEditor((IDiagramModel)this.diagramModel);
            this.parentFolder.getElements().remove((Object)this.diagramModel);
        }

        public void redo() {
            this.parentFolder.getElements().add(0, (Object)this.diagramModel);
            EditorManager.openDiagramEditor((IDiagramModel)this.diagramModel);
        }

        private void createMapView(IArchimateModel smodel) {
            this.diagramModel = IArchimateFactory.eINSTANCE.createArchimateDiagramModel();
            this.diagramModel.setName(Messages.CreateMapViewCheatSheetAction_6);
            this.parentFolder = this.model.getDefaultFolderForObject((EObject)this.diagramModel);
            this.parentFolder.getElements().add(0, (Object)this.diagramModel);
            int y = 20;
            for (IDiagramModel dm : this.model.getDiagramModels()) {
                if (dm == this.diagramModel) continue;
                IDiagramModelReference ref = IArchimateFactory.eINSTANCE.createDiagramModelReference();
                ref.setReferencedModel(dm);
                ref.setBounds(20, y, 400, 100);
                this.diagramModel.getChildren().add((Object)ref);
                y += 120;
                ref.setTextPosition(0);
            }
        }
    }
}

