/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.commandline.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.osgi.util.NLS;

public class ImportModelProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.ImportModelProvider_0;
    static final String OPTION_IMPORT_MODEL = "importModel";
    static final String OPTION_UPDATE = "importModel.update";
    static final String OPTION_UPDATE_ALL = "importModel.updateAll";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        IArchimateModel model = CommandLineState.getModel();
        if (model == null) {
            throw new IOException(Messages.ImportModelProvider_1);
        }
        String value = commandLine.getOptionValue(OPTION_IMPORT_MODEL);
        if (!StringUtils.isSet((String)value)) {
            this.logError(Messages.ImportModelProvider_2);
            return;
        }
        File modelFile = new File(value);
        if (!modelFile.exists()) {
            this.logError(NLS.bind((String)Messages.ImportModelProvider_3, (Object)value));
            return;
        }
        boolean update = commandLine.hasOption(OPTION_UPDATE);
        boolean updateAll = commandLine.hasOption(OPTION_UPDATE_ALL);
        ModelImporter importer = new ModelImporter();
        importer.setUpdate(update);
        importer.setUpdateAll(updateAll);
        importer.doImport(modelFile, model);
        this.logMessage(Messages.ImportModelProvider_4);
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_IMPORT_MODEL).hasArg().argName(Messages.ImportModelProvider_5).desc(Messages.ImportModelProvider_6).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_UPDATE).desc(Messages.ImportModelProvider_7).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_UPDATE_ALL).desc(Messages.ImportModelProvider_8).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_IMPORT_MODEL);
    }

    public int getPriority() {
        return 20;
    }

    protected String getLogPrefix() {
        return PREFIX;
    }
}

