/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas;

import com.archimatetool.canvas.ICanvasEditor;
import com.archimatetool.canvas.model.ICanvasModelBlock;
import com.archimatetool.canvas.model.ICanvasModelConnection;
import com.archimatetool.canvas.model.ICanvasModelImage;
import com.archimatetool.canvas.model.ICanvasModelSticky;
import com.archimatetool.editor.diagram.ICreationFactory;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;

public class CanvasModelFactory
implements ICreationFactory {
    private EClass fTemplate;
    private Object fParam;

    public CanvasModelFactory(EClass template) {
        this(template, null);
    }

    public CanvasModelFactory(EClass template, Object param) {
        this.fTemplate = template;
        this.fParam = param;
    }

    public boolean isUsedFor(IEditorPart editor) {
        return editor instanceof ICanvasEditor;
    }

    public Object getNewObject() {
        EObject object = this.fTemplate.getEPackage().getEFactoryInstance().create(this.fTemplate);
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider(object);
        if (object instanceof ICanvasModelSticky) {
            RGB rgb;
            ICanvasModelSticky sticky = (ICanvasModelSticky)object;
            Object object2 = this.fParam;
            if (object2 instanceof RGB && !(rgb = (RGB)object2).equals((Object)provider.getDefaultColor().getRGB())) {
                String color = ColorFactory.convertRGBToString((RGB)rgb);
                sticky.setFillColor(color);
            }
            sticky.setBorderColor("#C0C0C0");
        } else if (object instanceof ICanvasModelBlock) {
            ICanvasModelBlock block = (ICanvasModelBlock)object;
            block.setBorderColor("#000000");
        } else if (object instanceof ICanvasModelImage) {
            ICanvasModelImage image = (ICanvasModelImage)object;
            image.setBorderColor("#000000");
        } else if (object instanceof ICanvasModelConnection) {
            ICanvasModelConnection connection = (ICanvasModelConnection)object;
            Object object3 = this.fParam;
            if (object3 instanceof Integer) {
                Integer val = (Integer)object3;
                connection.setType(val);
            }
        }
        if (object instanceof ITextAlignment) {
            ITextAlignment textAlignment = (ITextAlignment)object;
            textAlignment.setTextAlignment(provider.getDefaultTextAlignment());
        }
        if (object instanceof ITextPosition) {
            ITextPosition textPosition = (ITextPosition)object;
            textPosition.setTextPosition(provider.getDefaultTextPosition());
        }
        if (object instanceof IDiagramModelObject) {
            IDiagramModelObject dmo = (IDiagramModelObject)object;
            Dimension size = provider.getDefaultSize();
            dmo.setBounds(0, 0, size.width, size.height);
        }
        return object;
    }

    public Object getObjectType() {
        return this.fTemplate;
    }
}

