/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.policies;

import com.archimatetool.canvas.model.ICanvasFactory;
import com.archimatetool.canvas.model.ICanvasModelImage;
import com.archimatetool.canvas.policies.Messages;
import com.archimatetool.editor.diagram.commands.AddDiagramModelReferenceCommand;
import com.archimatetool.editor.diagram.commands.AddDiagramObjectCommand;
import com.archimatetool.editor.diagram.dnd.AbstractDNDEditPolicy;
import com.archimatetool.editor.diagram.dnd.DiagramDropRequest;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.graphics.Image;

public class CanvasDNDEditPolicy
extends AbstractDNDEditPolicy {
    protected Command getDropCommand(final DiagramDropRequest request) {
        if (request.getTransferType() == LocalSelectionTransfer.getTransfer()) {
            return this.getLocalDropCommand(request);
        }
        final Command[] cmd = new Command[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (request.getTransferType() == FileTransfer.getInstance()) {
                    cmd[0] = CanvasDNDEditPolicy.this.getFileDropCommand(request);
                } else if (request.getTransferType() == URLTransfer.getInstance()) {
                    try {
                        cmd[0] = CanvasDNDEditPolicy.this.getURLDropCommand(request);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        return cmd[0];
    }

    private Command getFileDropCommand(DiagramDropRequest request) {
        String[] paths = (String[])request.getData();
        if (paths == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String path = stringArray[n2];
            if (this.isImagePath(path) && (file = new File(path)).exists() && file.canRead()) {
                files.add(file);
            }
            ++n2;
        }
        return this.createImageFileDropCommand(files, this.getDropLocation(request));
    }

    private Command getURLDropCommand(DiagramDropRequest request) throws IOException, URISyntaxException {
        String s = (String)request.getData();
        if (s == null) {
            return null;
        }
        if (PlatformUtils.isLinux()) {
            s = s.split("\n")[0];
        }
        if (!this.isImagePath(s = s.replaceAll(" ", "%20"))) {
            return null;
        }
        File file = null;
        URI uri = new URI(s);
        if ("file".equals(uri.getScheme())) {
            file = new File(uri);
        } else {
            file = File.createTempFile("archi-", s.substring(s.lastIndexOf(".")));
            file.deleteOnExit();
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (ReadableByteChannel rbc = Channels.newChannel(uri.toURL().openStream());){
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        if (file.exists() && file.canRead()) {
            files.add(file);
        }
        return this.createImageFileDropCommand(files, this.getDropLocation(request));
    }

    private Command createImageFileDropCommand(List<File> files, Point pt) {
        if (files == null || files.isEmpty()) {
            return null;
        }
        int origin = pt.x;
        int x = pt.x;
        int y = pt.y;
        IArchiveManager archiveManager = (IArchiveManager)this.getTargetContainer().getAdapter(IArchiveManager.class);
        CompoundCommand result = new CompoundCommand(Messages.CanvasDNDEditPolicy_0);
        for (File file : files) {
            String pathName;
            ICanvasModelImage canvasModelImage = ICanvasFactory.eINSTANCE.createCanvasModelImage();
            canvasModelImage.setName(Messages.CanvasDNDEditPolicy_1);
            try {
                pathName = archiveManager.addImageFromFile(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                continue;
            }
            canvasModelImage.setImagePath(pathName);
            Image image = null;
            try {
                image = archiveManager.createImage(pathName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            int image_width = image.getBounds().width;
            int image_height = image.getBounds().height;
            image.dispose();
            canvasModelImage.setBounds(x, y, image_width, image_height);
            result.add((Command)new AddDiagramObjectCommand(this.getTargetContainer(), (IDiagramModelObject)canvasModelImage));
            if ((x += image_width + 10) <= origin + 1000) continue;
            x = origin;
            y += image_height + 10;
        }
        return result;
    }

    private boolean isImagePath(String path) {
        return path.endsWith(".png") || path.endsWith(".bmp") || path.endsWith(".gif") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".tif") || path.endsWith(".tiff") || path.endsWith(".ico");
    }

    private Command getLocalDropCommand(DiagramDropRequest request) {
        if (!(request.getData() instanceof IStructuredSelection)) {
            return null;
        }
        Point pt = this.getDropLocation(request);
        int origin = pt.x;
        int x = pt.x;
        int y = pt.y;
        Object[] objects = ((IStructuredSelection)request.getData()).toArray();
        List<IDiagramModel> list = this.getDiagramRefsToAdd(objects);
        CompoundCommand result = new CompoundCommand(Messages.CanvasDNDEditPolicy_2);
        for (IDiagramModel diagramModel : list) {
            result.add((Command)new AddDiagramModelReferenceCommand(this.getTargetContainer(), diagramModel, x, y));
            if ((x += 150) <= origin + 400) continue;
            x = origin;
            y += 100;
        }
        return result;
    }

    private List<IDiagramModel> getDiagramRefsToAdd(Object[] objects) {
        ArrayList<IDiagramModel> list = new ArrayList<IDiagramModel>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IDiagramModel && object != this.getTargetDiagramModel() && !list.contains(object)) {
                list.add((IDiagramModel)object);
            }
            ++n2;
        }
        return list;
    }
}

