/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.propertysections;

import com.archimatetool.canvas.model.ICanvasPackage;
import com.archimatetool.canvas.model.INotesContent;
import com.archimatetool.canvas.propertysections.Messages;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.propertysections.AbstractECorePropertySection;
import com.archimatetool.editor.propertysections.IObjectFilter;
import com.archimatetool.editor.propertysections.ObjectFilter;
import com.archimatetool.editor.propertysections.PropertySectionTextControl;
import com.archimatetool.editor.ui.components.StyledTextControl;
import com.archimatetool.model.IArchimatePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class NotesSection
extends AbstractECorePropertySection {
    private static final String HELP_ID = "com.archimatetool.help.elementPropertySection";
    private PropertySectionTextControl fTextNotesControl;

    protected void createControls(Composite parent) {
        this.createLabel(parent, Messages.NotesSection_0, 115, 0);
        StyledTextControl styledTextControl = this.createStyledTextControl(parent, 0);
        styledTextControl.setMessage(Messages.NotesSection_2);
        this.fTextNotesControl = new PropertySectionTextControl((Control)styledTextControl.getControl(), ICanvasPackage.Literals.NOTES_CONTENT__NOTES){

            protected void textChanged(String oldText, String newText) {
                CompoundCommand result = new CompoundCommand();
                for (EObject notesContent : NotesSection.this.getEObjects()) {
                    EObjectFeatureCommand cmd;
                    if (!NotesSection.this.isAlive(notesContent) || !(cmd = new EObjectFeatureCommand(Messages.NotesSection_1, notesContent, (EStructuralFeature)ICanvasPackage.Literals.NOTES_CONTENT__NOTES, (Object)newText)).canExecute()) continue;
                    result.add((Command)cmd);
                }
                NotesSection.this.executeCommand(result.unwrap());
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fTextNotesControl.getTextControl(), HELP_ID);
    }

    protected void notifyChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (feature == ICanvasPackage.Literals.NOTES_CONTENT__NOTES || feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
            this.update();
        }
    }

    protected void update() {
        if (this.fIsExecutingCommand) {
            return;
        }
        this.fTextNotesControl.refresh((EObject)this.getFirstSelectedObject());
        this.fTextNotesControl.setEditable(!this.isLocked(this.getFirstSelectedObject()));
    }

    protected IObjectFilter getFilter() {
        return new Filter();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public static class Filter
    extends ObjectFilter {
        public boolean isRequiredType(Object object) {
            return object instanceof INotesContent;
        }

        public Class<?> getAdaptableType() {
            return INotesContent.class;
        }
    }
}

