/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.templates.model;

import com.archimatetool.canvas.CanvasEditorPlugin;
import com.archimatetool.canvas.ICanvasImages;
import com.archimatetool.canvas.templates.model.CanvasModelTemplate;
import com.archimatetool.canvas.templates.model.Messages;
import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.graphics.Image;

public class CanvasTemplateManager
extends TemplateManager {
    public static final String CANVAS_TEMPLATE_FILE_EXTENSION = ".archicanvas";

    protected ITemplateGroup loadInbuiltTemplates() {
        TemplateGroup group = new TemplateGroup(Messages.CanvasTemplateManager_0);
        File folder = CanvasEditorPlugin.getInstance().getTemplatesFolder();
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().toLowerCase().endsWith(CANVAS_TEMPLATE_FILE_EXTENSION)) {
                    try {
                        group.addTemplate(this.createTemplate(file));
                    }
                    catch (IOException ex) {
                        Logger.logError((String)"Error loading template", (Throwable)ex);
                    }
                }
                ++n2;
            }
        }
        return group;
    }

    public File getUserTemplatesManifestFile() {
        return new File(ArchiPlugin.getInstance().getWorkspaceFolder(), "canvasses.xml");
    }

    public String getTemplateFileExtension() {
        return CANVAS_TEMPLATE_FILE_EXTENSION;
    }

    public ITemplate createTemplate(File file) throws IOException {
        return new CanvasModelTemplate(file);
    }

    public Image getMainImage() {
        return ICanvasImages.ImageFactory.getImage("img/canvas.png");
    }
}

