/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.templates.wizard;

import com.archimatetool.canvas.model.ICanvasModel;
import com.archimatetool.canvas.templates.model.CanvasTemplateManager;
import com.archimatetool.canvas.templates.wizard.Messages;
import com.archimatetool.canvas.templates.wizard.NewCanvasFromTemplateWizardPage;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.compatibility.CompatibilityHandlerException;
import com.archimatetool.editor.model.compatibility.IncompatibleModelException;
import com.archimatetool.editor.model.compatibility.ModelCompatibility;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.util.UUIDFactory;
import com.archimatetool.templates.model.ITemplate;
import com.archimatetool.templates.model.TemplateManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;

public class NewCanvasFromTemplateWizard
extends Wizard {
    private NewCanvasFromTemplateWizardPage fMainPage;
    private TemplateManager fTemplateManager;
    private ITemplate fSelectedTemplate;

    public NewCanvasFromTemplateWizard() {
        this.setWindowTitle(Messages.NewCanvasFromTemplateWizard_0);
        this.fTemplateManager = new CanvasTemplateManager();
    }

    public void addPages() {
        this.fMainPage = new NewCanvasFromTemplateWizardPage(this.fTemplateManager);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performFinish() {
        this.fSelectedTemplate = this.fMainPage.getSelectedTemplate();
        return this.fSelectedTemplate != null;
    }

    public ICanvasModel getNewCanvasModel(IArchimateModel model) throws IOException {
        File file = this.getTempModelFile();
        if (file == null || !file.exists()) {
            return null;
        }
        Resource resource = IArchiveManager.FACTORY.createResource((File)file);
        ModelCompatibility modelCompatibility = new ModelCompatibility(resource);
        try {
            resource.load(null);
        }
        catch (IOException ex) {
            if (resource.getErrors().isEmpty()) {
                throw ex;
            }
            try {
                modelCompatibility.checkErrors();
            }
            catch (IncompatibleModelException ex1) {
                throw new IOException(NLS.bind((String)Messages.NewCanvasFromTemplateWizard_1, (Object)file) + "\n" + ex1.getMessage());
            }
        }
        try {
            modelCompatibility.fixCompatibility();
        }
        catch (CompatibilityHandlerException compatibilityHandlerException) {}
        IArchimateModel templateModel = (IArchimateModel)resource.getContents().get(0);
        IFolder folderViews = templateModel.getFolder(FolderType.DIAGRAMS);
        ICanvasModel canvasModel = (ICanvasModel)folderViews.getElements().get(0);
        UUIDFactory.generateNewIDs((EObject)canvasModel);
        if (IArchiveManager.FACTORY.isArchiveFile((File)file)) {
            IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
            archiveManager.loadImagesFromModelFile(file);
        }
        file.delete();
        return canvasModel;
    }

    public File getTempModelFile() throws IOException {
        if (this.fSelectedTemplate == null) {
            return null;
        }
        File zipFile = this.fSelectedTemplate.getFile();
        File tmpFile = File.createTempFile("~architemplate", null);
        tmpFile.deleteOnExit();
        return ZipUtils.extractZipEntry((File)zipFile, (String)"model.archimate", (File)tmpFile);
    }

    public void dispose() {
        super.dispose();
        this.fTemplateManager.dispose();
    }
}

