/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.templates.wizard;

import com.archimatetool.canvas.model.ICanvasModel;
import com.archimatetool.canvas.templates.model.CanvasModelTemplate;
import com.archimatetool.canvas.templates.model.CanvasTemplateManager;
import com.archimatetool.canvas.templates.wizard.Messages;
import com.archimatetool.canvas.templates.wizard.SaveCanvasAsTemplateToCollectionWizardPage;
import com.archimatetool.canvas.templates.wizard.SaveCanvasAsTemplateWizardPage;
import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.utils.ZipUtils;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.util.UUIDFactory;
import com.archimatetool.templates.model.ITemplateGroup;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.TemplateUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveCanvasAsTemplateWizard
extends Wizard {
    private IArchimateModel fModel;
    private ICanvasModel fCanvasModel;
    private SaveCanvasAsTemplateWizardPage fPage1;
    private SaveCanvasAsTemplateToCollectionWizardPage fPage2;
    private File fZipFile;
    private String fTemplateName;
    private String fTemplateDescription;
    private boolean fIncludeThumbnail;
    private ITemplateGroup fSelectedTemplateGroup;
    private boolean fDoStoreInCollection;
    private TemplateManager fTemplateManager;

    public SaveCanvasAsTemplateWizard(ICanvasModel canvasModel) {
        this.setWindowTitle(Messages.SaveCanvasAsTemplateWizard_0);
        this.createTempModel(canvasModel);
        this.fTemplateManager = new CanvasTemplateManager();
    }

    public void addPages() {
        this.fPage1 = new SaveCanvasAsTemplateWizardPage(this.fCanvasModel, this.fTemplateManager);
        this.addPage((IWizardPage)this.fPage1);
        this.fPage2 = new SaveCanvasAsTemplateToCollectionWizardPage(this.fTemplateManager);
        this.addPage((IWizardPage)this.fPage2);
    }

    public boolean performFinish() {
        boolean result;
        this.fPage1.storePreferences();
        this.fZipFile = new File(this.fPage1.getFileName());
        if (this.fZipFile.exists() && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.SaveCanvasAsTemplateWizard_1, (String)NLS.bind((String)Messages.SaveCanvasAsTemplateWizard_2, (Object)this.fZipFile)))) {
            return false;
        }
        this.fTemplateName = this.fPage1.getTemplateName();
        this.fTemplateDescription = this.fPage1.getTemplateDescription();
        this.fIncludeThumbnail = this.fPage1.includeThumbnail();
        this.fDoStoreInCollection = this.fPage2.doStoreInCollection();
        this.fSelectedTemplateGroup = this.fPage2.getTemplateGroup();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SaveCanvasAsTemplateWizard.this.createZipFile(SaveCanvasAsTemplateWizard.this.fZipFile);
                    if (SaveCanvasAsTemplateWizard.this.fDoStoreInCollection) {
                        SaveCanvasAsTemplateWizard.this.fTemplateManager.addTemplateEntry(SaveCanvasAsTemplateWizard.this.fZipFile, SaveCanvasAsTemplateWizard.this.fSelectedTemplateGroup);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)SaveCanvasAsTemplateWizard.this.getShell(), (String)Messages.SaveCanvasAsTemplateWizard_3, (String)ex.getMessage());
                        }
                    });
                }
            }
        });
        return true;
    }

    private void createZipFile(File zipFile) throws IOException {
        File parent = zipFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream zOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            String manifest = this.createManifest();
            ZipUtils.addStringToZip((String)manifest, (String)"manifest.xml", (ZipOutputStream)zOut, (Charset)Charset.forName("UTF-8"));
            File tempFile = this.saveModelToTempFile();
            ZipUtils.addFileToZip((File)tempFile, (String)"model.archimate", (ZipOutputStream)zOut);
            tempFile.delete();
            if (this.fIncludeThumbnail) {
                Image image = TemplateUtils.createThumbnailImage((IDiagramModel)this.fCanvasModel);
                ZipUtils.addImageToZip((Image)image, (String)"Thumbnails/1.png", (ZipOutputStream)zOut, (int)5, null);
                image.dispose();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String createManifest() throws IOException {
        CanvasModelTemplate template = new CanvasModelTemplate();
        template.setName(this.fTemplateName);
        template.setDescription(this.fTemplateDescription);
        if (this.fIncludeThumbnail) {
            template.setKeyThumbnailPath("Thumbnails/1.png");
        }
        return template.createManifest();
    }

    private File saveModelToTempFile() throws IOException {
        File tmpFile = File.createTempFile("architemplate", null);
        tmpFile.deleteOnExit();
        this.fModel.setFile(tmpFile);
        IArchiveManager archiveManager = (IArchiveManager)this.fModel.getAdapter(IArchiveManager.class);
        archiveManager.saveModel();
        return tmpFile;
    }

    private void createTempModel(ICanvasModel canvasModel) {
        this.fModel = IArchimateFactory.eINSTANCE.createArchimateModel();
        this.fModel.setDefaults();
        this.fModel.setVersion("5.0.0");
        this.fModel.setName(Messages.SaveCanvasAsTemplateWizard_4);
        this.fCanvasModel = this.createCanvasCopy(canvasModel);
        IFolder folder = this.fModel.getDefaultFolderForObject((EObject)this.fCanvasModel);
        folder.getElements().add((Object)this.fCanvasModel);
        IArchiveManager archiveManager = ((IArchiveManager)canvasModel.getAdapter(IArchiveManager.class)).clone(this.fModel);
        this.fModel.setAdapter(IArchiveManager.class, (Object)archiveManager);
    }

    private ICanvasModel createCanvasCopy(ICanvasModel canvasModel) {
        ICanvasModel copyCanvas = (ICanvasModel)EcoreUtil.copy((EObject)canvasModel);
        ArrayList<IDiagramModelReference> toRemove = new ArrayList<IDiagramModelReference>();
        TreeIterator iter = copyCanvas.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelReference)) continue;
            IDiagramModelReference ref = (IDiagramModelReference)eObject;
            toRemove.add(ref);
        }
        for (IDiagramModelReference ref : toRemove) {
            DiagramCommandFactory.createDeleteDiagramObjectCommand((IDiagramModelObject)ref).execute();
        }
        UUIDFactory.generateNewIDs((EObject)copyCanvas);
        return copyCanvas;
    }

    public void dispose() {
        super.dispose();
        this.fTemplateManager.dispose();
        this.fCanvasModel = null;
        this.fModel = null;
    }
}

