/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.canvas.templates.wizard;

import com.archimatetool.canvas.CanvasEditorPlugin;
import com.archimatetool.canvas.model.ICanvasModel;
import com.archimatetool.canvas.templates.wizard.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.templates.model.TemplateManager;
import com.archimatetool.templates.wizard.TemplateUtils;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SaveCanvasAsTemplateWizardPage
extends WizardPage {
    private static String HELP_ID = "com.archimatetool.help.SaveCanvasAsTemplateWizardPage";
    private ICanvasModel fCanvasModel;
    private Text fFileTextField;
    private Text fNameTextField;
    private Text fDescriptionTextField;
    private Label fPreviewLabel;
    private Button fButtonIncludeThumbnail;
    private TemplateManager fTemplateManager;
    private static final String PREFS_LAST_FOLDER = "SaveCanvasAsTemplateLastFolder";

    public SaveCanvasAsTemplateWizardPage(ICanvasModel canvasModel, TemplateManager templateManager) {
        super("SaveCanvasAsTemplateWizardPage");
        this.setTitle(Messages.SaveCanvasAsTemplateWizardPage_0);
        this.setDescription(Messages.SaveCanvasAsTemplateWizardPage_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/new_wiz.png"));
        this.fCanvasModel = canvasModel;
        this.fTemplateManager = templateManager;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group fileComposite = new Group(container, 0);
        fileComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        fileComposite.setLayout((Layout)layout);
        Label label = new Label((Composite)fileComposite, 0);
        label.setText(Messages.SaveCanvasAsTemplateWizardPage_2);
        this.fFileTextField = UIUtils.createSingleTextControl((Composite)fileComposite, (int)2048, (boolean)false);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        String defaultFileName = Messages.SaveCanvasAsTemplateWizardPage_3 + ".archicanvas";
        String lastFolderName = CanvasEditorPlugin.getInstance().getPreferenceStore().getString(PREFS_LAST_FOLDER);
        File lastFolder = new File(lastFolderName);
        if (lastFolder.exists() && lastFolder.isDirectory()) {
            this.fFileTextField.setText(new File(lastFolder, defaultFileName).getPath());
        } else {
            this.fFileTextField.setText(new File(System.getProperty("user.home"), defaultFileName).getPath());
        }
        this.fFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveCanvasAsTemplateWizardPage.this.validateFields();
            }
        });
        Button fileButton = new Button((Composite)fileComposite, 8);
        fileButton.setText(Messages.SaveCanvasAsTemplateWizardPage_4);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = SaveCanvasAsTemplateWizardPage.this.chooseFile();
                if (file != null) {
                    SaveCanvasAsTemplateWizardPage.this.fFileTextField.setText(file.getPath());
                }
            }
        });
        Group fieldGroup = new Group(container, 0);
        fieldGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        fieldGroup.setLayout((Layout)layout);
        label = new Label((Composite)fieldGroup, 0);
        label.setText(Messages.SaveCanvasAsTemplateWizardPage_5);
        this.fNameTextField = UIUtils.createSingleTextControl((Composite)fieldGroup, (int)2048, (boolean)false);
        this.fNameTextField.setLayoutData((Object)new GridData(768));
        if (StringUtils.isSet((String)this.fCanvasModel.getName())) {
            this.fNameTextField.setText(this.fCanvasModel.getName());
        }
        this.fNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveCanvasAsTemplateWizardPage.this.validateFields();
            }
        });
        label = new Label((Composite)fieldGroup, 0);
        label.setText(Messages.SaveCanvasAsTemplateWizardPage_6);
        GridData gd = new GridData(0, 128, false, false);
        label.setLayoutData((Object)gd);
        this.fDescriptionTextField = new Text((Composite)fieldGroup, 2626);
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 550;
        this.fDescriptionTextField.setLayoutData((Object)gd);
        if (StringUtils.isSet((String)this.fCanvasModel.getDocumentation())) {
            this.fDescriptionTextField.setText(this.fCanvasModel.getDocumentation());
        }
        Group thumbsGroup = new Group(container, 0);
        thumbsGroup.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout(2, false);
        thumbsGroup.setLayout((Layout)layout);
        this.fButtonIncludeThumbnail = new Button((Composite)thumbsGroup, 32);
        this.fButtonIncludeThumbnail.setText(Messages.SaveCanvasAsTemplateWizardPage_7);
        this.fButtonIncludeThumbnail.setSelection(true);
        this.fButtonIncludeThumbnail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveCanvasAsTemplateWizardPage.this.fPreviewLabel.setEnabled(SaveCanvasAsTemplateWizardPage.this.fButtonIncludeThumbnail.getSelection());
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fButtonIncludeThumbnail.setLayoutData((Object)gd);
        label = new Label((Composite)thumbsGroup, 0);
        label.setText(Messages.SaveCanvasAsTemplateWizardPage_8 + "  ");
        gd = new GridData(0, 128, false, false);
        label.setLayoutData((Object)gd);
        this.fPreviewLabel = new Label((Composite)thumbsGroup, 2048);
        this.fPreviewLabel.setAlignment(0x1000000);
        this.fPreviewLabel.setBackground(new Color(255, 255, 255));
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 150;
        this.fPreviewLabel.setLayoutData((Object)gd);
        this.fPreviewLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SaveCanvasAsTemplateWizardPage.this.disposePreviewImage();
            }
        });
        this.fPreviewLabel.addControlListener((ControlListener)new ControlAdapter(){
            int oldTime;

            public void controlResized(ControlEvent e) {
                if (e.time - this.oldTime > 50) {
                    TemplateUtils.createThumbnailPreviewImage((IDiagramModel)SaveCanvasAsTemplateWizardPage.this.fCanvasModel, (Label)SaveCanvasAsTemplateWizardPage.this.fPreviewLabel);
                }
                this.oldTime = e.time;
            }
        });
        this.validateFields();
    }

    public String getFileName() {
        return this.fFileTextField.getText();
    }

    public String getTemplateName() {
        return this.fNameTextField.getText();
    }

    public String getTemplateDescription() {
        return this.fDescriptionTextField.getText();
    }

    public boolean includeThumbnail() {
        return this.fButtonIncludeThumbnail.getSelection();
    }

    private File chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.SaveCanvasAsTemplateWizardPage_9);
        if (!PlatformUtils.isMac()) {
            dialog.setFilterExtensions(new String[]{"*" + this.fTemplateManager.getTemplateFileExtension(), "*.*"});
        }
        File file = new File(this.fFileTextField.getText());
        dialog.setFileName(file.getName());
        dialog.setOverwrite(false);
        Object path = dialog.open();
        if (path != null) {
            if (dialog.getFilterIndex() == 0 && !((String)path).endsWith(".archicanvas")) {
                path = (String)path + ".archicanvas";
            }
            return new File((String)path);
        }
        return null;
    }

    private void validateFields() {
        String fileName = this.getFileName();
        if (!StringUtils.isSetAfterTrim((String)fileName)) {
            this.updateStatus(Messages.SaveCanvasAsTemplateWizardPage_10);
            return;
        }
        String name = this.getTemplateName();
        if (!StringUtils.isSetAfterTrim((String)name)) {
            this.updateStatus(Messages.SaveCanvasAsTemplateWizardPage_11);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void disposePreviewImage() {
        if (this.fPreviewLabel != null && this.fPreviewLabel.getImage() != null) {
            this.fPreviewLabel.getImage().dispose();
        }
    }

    void storePreferences() {
        File parentFile = new File(this.getFileName()).getAbsoluteFile().getParentFile();
        if (parentFile != null) {
            IPreferenceStore store = CanvasEditorPlugin.getInstance().getPreferenceStore();
            store.setValue(PREFS_LAST_FOLDER, parentFile.getAbsolutePath());
        }
    }
}

