/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;

public class PaletteColorUtil {
    public static Color PALETTE_BACKGROUND;
    public static Color PALETTE_LABEL_FOREGROUND;
    public static Color PALETTE_TOOLBAR_BACKGROUND;
    public static Color PALETTE_TITLE_LABEL_FOREGROUND;
    public static Color PALETTE_TITLE_LABEL_BACKGROUND_START;
    public static Color PALETTE_TITLE_LABEL_BACKGROUND_END;
    public static Color PALETTE_ARROW_BUTTON_BACKGROUND;
    public static Color PALETTE_ARROW_BUTTON_FOREGROUND;
    public static final Color WIDGET_BACKGROUND;
    public static final Color WIDGET_NORMAL_SHADOW;
    public static final Color WIDGET_DARK_SHADOW;
    public static final Color WIDGET_LIST_BACKGROUND;
    public static final Color INFO_FOREGROUND;
    public static final Color ARROW_HOVER;
    private static final Color HOVER_COLOR;
    private static final Color SELECTED_COLOR;
    private static final Color HOVER_COLOR_HICONTRAST;
    private static final Color SELECTED_COLOR_HICONTRAST;
    public static final Color WIDGET_BACKGROUND_LIST_BACKGROUND_40;
    public static final Color WIDGET_BACKGROUND_LIST_BACKGROUND_60;
    public static final Color WIDGET_BACKGROUND_LIST_BACKGROUND_85;
    public static final Color WIDGET_BACKGROUND_LIST_BACKGROUND_90;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_40;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_45;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_65;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_70;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_80;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_90;
    public static final Color WIDGET_BACKGROUND_NORMAL_SHADOW_95;

    static {
        PaletteColorUtil.initPaletteColors();
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(e -> {
            if (e.getProperty().startsWith("org.eclipse.gef")) {
                PaletteColorUtil.initPaletteColors();
            }
        });
        WIDGET_BACKGROUND = ColorConstants.button;
        WIDGET_NORMAL_SHADOW = ColorConstants.buttonDarker;
        WIDGET_DARK_SHADOW = ColorConstants.buttonDarkest;
        WIDGET_LIST_BACKGROUND = ColorConstants.listBackground;
        INFO_FOREGROUND = ColorConstants.tooltipForeground;
        ARROW_HOVER = new Color(229, 229, 219);
        HOVER_COLOR = new Color(252, 228, 179);
        SELECTED_COLOR = new Color(207, 227, 250);
        HOVER_COLOR_HICONTRAST = new Color(0, 128, 0);
        SELECTED_COLOR_HICONTRAST = new Color(128, 0, 128);
        WIDGET_BACKGROUND_LIST_BACKGROUND_40 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_LIST_BACKGROUND, (double)0.4);
        WIDGET_BACKGROUND_LIST_BACKGROUND_60 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_LIST_BACKGROUND, (double)0.6);
        WIDGET_BACKGROUND_LIST_BACKGROUND_85 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_LIST_BACKGROUND, (double)0.85);
        WIDGET_BACKGROUND_LIST_BACKGROUND_90 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_LIST_BACKGROUND, (double)0.9);
        WIDGET_BACKGROUND_NORMAL_SHADOW_40 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.4);
        WIDGET_BACKGROUND_NORMAL_SHADOW_45 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.45);
        WIDGET_BACKGROUND_NORMAL_SHADOW_65 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.65);
        WIDGET_BACKGROUND_NORMAL_SHADOW_70 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.7);
        WIDGET_BACKGROUND_NORMAL_SHADOW_80 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.8);
        WIDGET_BACKGROUND_NORMAL_SHADOW_90 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.9);
        WIDGET_BACKGROUND_NORMAL_SHADOW_95 = FigureUtilities.mixColors((Color)WIDGET_BACKGROUND, (Color)WIDGET_NORMAL_SHADOW, (double)0.95);
    }

    private static Color getThemeColor(String id, RGB defaultColor) {
        IThemeRegistry reg = WorkbenchPlugin.getDefault().getThemeRegistry();
        ColorDefinition colorDef = reg.findColor(id);
        if (colorDef != null && colorDef.getValue() != null) {
            defaultColor = colorDef.getValue();
        }
        return new Color(defaultColor);
    }

    private static void initPaletteColors() {
        PALETTE_BACKGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_BACKGROUND", new RGB(255, 255, 255));
        PALETTE_LABEL_FOREGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_LABEL_FOREGROUND", new RGB(0, 0, 0));
        PALETTE_TOOLBAR_BACKGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_TOOLBAR_BACKGROUND", new RGB(245, 245, 245));
        PALETTE_TITLE_LABEL_FOREGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_TITLE_LABEL_FOREGROUND", ColorConstants.listForeground.getRGB());
        PALETTE_TITLE_LABEL_BACKGROUND_START = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_TITLE_LABEL_BACKGROUND_START", ColorConstants.listBackground.getRGB());
        PALETTE_TITLE_LABEL_BACKGROUND_END = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_TITLE_LABEL_BACKGROUND_END", ColorConstants.button.getRGB());
        PALETTE_ARROW_BUTTON_BACKGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_ARROW_BUTTON_BACKGROUND", ColorConstants.listBackground.getRGB());
        PALETTE_ARROW_BUTTON_FOREGROUND = PaletteColorUtil.getThemeColor("org.eclipse.gef.PALETTE_ARROW_BUTTON_FOREGROUND", ColorConstants.buttonDarkest.getRGB());
    }

    public static Color getHoverColor() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            return HOVER_COLOR_HICONTRAST;
        }
        return HOVER_COLOR;
    }

    public static Color getSelectedColor() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display.getHighContrast()) {
            return SELECTED_COLOR_HICONTRAST;
        }
        return SELECTED_COLOR;
    }
}

