/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class ConnectionEndpointTracker
extends TargetingTool
implements DragTracker {
    private static final int FLAG_SOURCE_FEEBBACK = 64;
    protected static final int MAX_FLAG = 64;
    private String commandName;
    private List exclusionSet;
    private ConnectionEditPart connectionEditPart;

    public ConnectionEndpointTracker(ConnectionEditPart cep) {
        this.setConnectionEditPart(cep);
        this.setDisabledCursor(Cursors.NO);
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.isInState(19)) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    public void commitDrag() {
        this.eraseSourceFeedback();
        this.eraseTargetFeedback();
        this.executeCurrentCommand();
    }

    @Override
    protected Request createTargetRequest() {
        ReconnectRequest request = new ReconnectRequest(this.getCommandName());
        request.setConnectionEditPart(this.getConnectionEditPart());
        return request;
    }

    @Override
    public void deactivate() {
        this.eraseSourceFeedback();
        this.getCurrentViewer().setFocus(null);
        super.deactivate();
    }

    protected void eraseSourceFeedback() {
        if (!this.getFlag(64)) {
            return;
        }
        this.setFlag(64, false);
        this.getConnectionEditPart().eraseSourceFeedback(this.getTargetRequest());
    }

    @Override
    protected String getCommandName() {
        return this.commandName;
    }

    protected Connection getConnection() {
        return (Connection)this.getConnectionEditPart().getFigure();
    }

    protected ConnectionEditPart getConnectionEditPart() {
        return this.connectionEditPart;
    }

    @Override
    protected String getDebugName() {
        return "Connection Endpoint Tool";
    }

    @Override
    protected Collection getExclusionSet() {
        if (this.exclusionSet == null) {
            this.exclusionSet = new ArrayList();
            this.exclusionSet.add(this.getConnection());
        }
        return this.exclusionSet;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.executeCurrentCommand();
        }
        return true;
    }

    @Override
    protected boolean handleDragInProgress() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showSourceFeedback();
        this.showTargetFeedback();
        this.setCurrentCommand(this.getCommand());
        return true;
    }

    @Override
    protected boolean handleDragStarted() {
        this.stateTransition(1, 4);
        return false;
    }

    @Override
    protected boolean handleHover() {
        if (this.isInDragInProgress()) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    @Override
    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            if (this.stateTransition(1, 32)) {
                if (this.isTarget()) {
                    this.getCurrentViewer().setFocus(this.getConnectionEditPart().getTarget());
                    this.getCurrentViewer().reveal(this.getConnectionEditPart().getTarget());
                } else {
                    this.getCurrentViewer().setFocus(this.getConnectionEditPart().getSource());
                    this.getCurrentViewer().reveal(this.getConnectionEditPart().getSource());
                }
            }
            int direction = 0;
            switch (e.keyCode) {
                case 0x1000002: {
                    direction = 4;
                    break;
                }
                case 0x1000001: {
                    direction = 1;
                    break;
                }
                case 0x1000004: {
                    direction = this.isCurrentViewerMirrored() ? 8 : 16;
                    break;
                }
                case 0x1000003: {
                    direction = this.isCurrentViewerMirrored() ? 16 : 8;
                }
            }
            boolean consumed = false;
            if (direction != 0 && e.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                e.stateMask |= 0x40000;
                e.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(e)) {
                    this.navigateNextAnchor(0);
                    return true;
                }
            }
        }
        if (e.character == '/' || e.character == '\\') {
            e.stateMask |= 0x40000;
            if (this.getCurrentViewer().getKeyHandler().keyPressed(e)) {
                if (this.getCurrentViewer().getFocusEditPart() != this.getConnectionEditPart()) {
                    this.navigateNextAnchor(0);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isTarget() {
        return this.getCommandName() == "Reconnection target";
    }

    boolean navigateNextAnchor(int direction) {
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        AccessibleAnchorProvider provider = (AccessibleAnchorProvider)focus.getAdapter(AccessibleAnchorProvider.class);
        if (provider == null) {
            return false;
        }
        List list = this.isTarget() ? provider.getTargetAnchorLocations() : provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        int i = 0;
        while (i < list.size()) {
            int d;
            Point p = (Point)list.get(i);
            if (!(p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance)) {
                distance = d;
                next = p;
            }
            ++i;
        }
        if (next != null) {
            this.placeMouseInViewer(next);
            return true;
        }
        return false;
    }

    public void setCommandName(String newCommandName) {
        this.commandName = newCommandName;
    }

    public void setConnectionEditPart(ConnectionEditPart cep) {
        this.connectionEditPart = cep;
    }

    protected void showSourceFeedback() {
        this.getConnectionEditPart().showSourceFeedback(this.getTargetRequest());
        this.setFlag(64, true);
    }

    @Override
    protected void updateTargetRequest() {
        ReconnectRequest request = (ReconnectRequest)this.getTargetRequest();
        Point p = this.getLocation();
        request.setLocation(p);
    }
}

