/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.swt.widgets.Display;

public abstract class TargetingTool
extends AbstractTool {
    private static final int FLAG_LOCK_TARGET = 16;
    private static final int FLAG_TARGET_FEEDBACK = 32;
    protected static final int MAX_FLAG = 32;
    private Request targetRequest;
    private EditPart targetEditPart;
    private AutoexposeHelper exposeHelper;

    protected Request createTargetRequest() {
        Request request = new Request();
        request.setType(this.getCommandName());
        return request;
    }

    @Override
    public void deactivate() {
        if (this.isHoverActive()) {
            this.resetHover();
        }
        this.eraseTargetFeedback();
        this.targetEditPart = null;
        this.targetRequest = null;
        this.setAutoexposeHelper(null);
        super.deactivate();
    }

    protected void doAutoexpose() {
        if (this.exposeHelper == null) {
            return;
        }
        if (this.exposeHelper.step(this.getLocation())) {
            this.handleAutoexpose();
            Display.getCurrent().timerExec(10, (Runnable)new QueuedAutoexpose());
        } else {
            this.setAutoexposeHelper(null);
        }
    }

    protected void eraseTargetFeedback() {
        if (!this.isShowingTargetFeedback()) {
            return;
        }
        this.setFlag(32, false);
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().eraseTargetFeedback(this.getTargetRequest());
        }
    }

    @Override
    protected Command getCommand() {
        if (this.getTargetEditPart() == null) {
            return null;
        }
        return this.getTargetEditPart().getCommand(this.getTargetRequest());
    }

    protected Collection getExclusionSet() {
        return Collections.EMPTY_LIST;
    }

    protected EditPartViewer.Conditional getTargetingConditional() {
        return new EditPartViewer.Conditional(){

            @Override
            public boolean evaluate(EditPart editpart) {
                return editpart.getTargetEditPart(TargetingTool.this.getTargetRequest()) != null;
            }
        };
    }

    protected EditPart getTargetEditPart() {
        return this.targetEditPart;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.setTargetRequest(this.createTargetRequest());
        }
        return this.targetRequest;
    }

    protected void handleAutoexpose() {
        this.handleMove();
    }

    protected boolean handleEnteredEditPart() {
        this.updateTargetRequest();
        this.showTargetFeedback();
        return true;
    }

    protected boolean handleExitingEditPart() {
        this.resetHover();
        this.eraseTargetFeedback();
        return true;
    }

    protected boolean handleHoverStop() {
        return false;
    }

    @Override
    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.setCurrentCommand(UnexecutableCommand.INSTANCE);
        return true;
    }

    protected final void handleLeavingEditPart() throws Exception {
    }

    @Override
    protected boolean handleViewerExited() {
        this.setTargetEditPart(null);
        return true;
    }

    protected boolean isShowingTargetFeedback() {
        return this.getFlag(32);
    }

    protected boolean isTargetLocked() {
        return this.getFlag(16);
    }

    protected void lockTargetEditPart(EditPart editpart) {
        if (editpart == null) {
            this.unlockTargetEditPart();
            return;
        }
        this.setFlag(16, true);
        this.setTargetEditPart(editpart);
    }

    @Override
    protected void resetFlags() {
        this.setFlag(16, false);
        super.resetFlags();
    }

    protected void resetHover() {
        if (this.isHoverActive()) {
            this.handleHoverStop();
        }
        this.setHoverActive(false);
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        this.exposeHelper = helper;
        if (this.exposeHelper == null) {
            return;
        }
        Display.getCurrent().asyncExec((Runnable)new QueuedAutoexpose());
    }

    protected void setTargetEditPart(EditPart editpart) {
        if (editpart != this.targetEditPart) {
            if (this.targetEditPart != null) {
                this.handleExitingEditPart();
            }
            this.targetEditPart = editpart;
            if (this.getTargetRequest() instanceof TargetRequest) {
                ((TargetRequest)((Object)this.getTargetRequest())).setTargetEditPart(this.targetEditPart);
            }
            this.handleEnteredEditPart();
        }
    }

    protected void setTargetRequest(Request req) {
        this.targetRequest = req;
    }

    protected void showTargetFeedback() {
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().showTargetFeedback(this.getTargetRequest());
        }
        this.setFlag(32, true);
    }

    protected void unlockTargetEditPart() {
        this.setFlag(16, false);
        this.updateTargetUnderMouse();
    }

    protected void updateAutoexposeHelper() {
        if (this.exposeHelper != null) {
            return;
        }
        AutoexposeHelper.Search search = new AutoexposeHelper.Search(this.getLocation());
        this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), Collections.EMPTY_LIST, search);
        this.setAutoexposeHelper(search.result);
    }

    protected void updateTargetRequest() {
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            EditPart editPart = null;
            if (this.getCurrentViewer() != null) {
                editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            }
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            boolean changed = this.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }

    protected AutoexposeHelper getAutoexposeHelper() {
        return this.exposeHelper;
    }

    class QueuedAutoexpose
    implements Runnable {
        QueuedAutoexpose() {
        }

        @Override
        public void run() {
            if (TargetingTool.this.exposeHelper != null) {
                TargetingTool.this.doAutoexpose();
            }
        }
    }
}

