/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.CustomizeAction;
import org.eclipse.gef.ui.palette.LayoutAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PinDrawerAction;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class PaletteContextMenuProvider
extends ContextMenuProvider {
    public PaletteContextMenuProvider(PaletteViewer palette) {
        super(palette);
    }

    protected PaletteViewer getPaletteViewer() {
        return (PaletteViewer)this.getViewer();
    }

    @Override
    public void buildContextMenu(IMenuManager menu) {
        GEFActionConstants.addStandardActionGroups(menu);
        EditPart selectedPart = (EditPart)this.getPaletteViewer().getSelectedEditParts().get(0);
        IPinnableEditPart pinnablePart = (IPinnableEditPart)selectedPart.getAdapter(IPinnableEditPart.class);
        if (pinnablePart != null && pinnablePart.canBePinned()) {
            menu.appendToGroup("additions", (IAction)new PinDrawerAction(pinnablePart));
        }
        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutAction(this.getPaletteViewer().getPaletteViewerPreferences()));
        if (this.getPaletteViewer().getCustomizer() != null) {
            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new CustomizeAction(this.getPaletteViewer()));
        }
        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new SettingsAction(this.getPaletteViewer()));
    }
}

