/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.views.palette;

import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class PaletteView
extends PageBookView {
    private boolean viewInPage = true;
    private static final boolean isMac = "cocoa".equals(SWT.getPlatform());
    public static final String ID = "org.eclipse.gef.ui.palette_view";
    private IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PaletteView.this.viewInPage = page.findViewReference(PaletteView.ID) != null;
            PaletteView.this.partActivated(PaletteView.this.getBootstrapPart());
        }
    };

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        if (isMac && pageRec.page instanceof PaletteViewerPage && !pageRec.page.getControl().isDisposed()) {
            pageRec.page.getControl().redraw();
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(GEFMessages.Palette_Not_Available);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSite().getPage().getWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
    }

    public void dispose() {
        this.getSite().getPage().getWorkbenchWindow().removePerspectiveListener(this.perspectiveListener);
        super.dispose();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        PalettePage page = (PalettePage)part.getAdapter(PalettePage.class);
        if (page != null) {
            page.createControl((Composite)this.getPageBook());
            this.initPage(page);
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        rec.page.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return this.viewInPage && part instanceof IEditorPart;
    }
}

