/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ArchiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.archimatetool.editor";
    public static final String DROPINS_DIRECTORY = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    public static ArchiPlugin INSTANCE;

    public static ArchiPlugin getInstance() {
        return INSTANCE;
    }

    public ArchiPlugin() {
        INSTANCE = this;
    }

    public File getUserDataFolder() {
        File file = this.getUserPropertyLocation("data.location");
        return file != null ? file : new File(System.getProperty("user.home") + "/Documents/Archi");
    }

    public File getUserDropinsFolder() {
        String dropinsDirProperty = this.getBundle().getBundleContext().getProperty(DROPINS_DIRECTORY);
        if (dropinsDirProperty != null && dropinsDirProperty.length() != 0) {
            dropinsDirProperty = this.substituteVariablesForDropinsPath(dropinsDirProperty);
            return new File(dropinsDirProperty);
        }
        return null;
    }

    public File getWorkspaceFolder() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            Logger.logWarning("Instance Location is null. Using user.home");
            return new File(System.getProperty("user.home"), "Archi");
        }
        URL url = instanceLoc.getURL();
        return url != null ? new File(url.getPath()) : new File(System.getProperty("user.home"), "Archi");
    }

    public File getPluginFolder() {
        try {
            URL url = FileLocator.resolve((URL)this.getBundle().getEntry("/"));
            return new File(url.getPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getResourceString(String key) {
        return Platform.getResourceString((Bundle)Platform.getBundle((String)PLUGIN_ID), (String)key);
    }

    public String getId() {
        return this.getBundle().getSymbolicName();
    }

    public String getProductName() {
        return Platform.getProduct() != null ? Platform.getProduct().getName() : (String)this.getBundle().getHeaders().get("Bundle-Name");
    }

    public String getVersion() {
        Version v = this.getBundle().getVersion();
        return v.getMajor() + "." + v.getMinor() + "." + v.getMicro();
    }

    public String getBuild() {
        return this.getBundle().getVersion().getQualifier();
    }

    public File getUserPropertyLocation(String argument) {
        String path = System.getProperty(argument);
        if (path == null || path.length() == 0) {
            return null;
        }
        path = path.replace("@user.home", System.getProperty("user.home"));
        try {
            Path p = Paths.get(path, new String[0]);
            return p.toFile();
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    private String substituteVariablesForDropinsPath(String path) {
        int endIndex;
        if (path == null) {
            return path;
        }
        int beginIndex = path.indexOf(37);
        if (beginIndex == -1) {
            return path;
        }
        if ((endIndex = path.indexOf(37, ++beginIndex)) == -1) {
            return path;
        }
        String var = path.substring(beginIndex, endIndex);
        if (var.length() == 0 || var.indexOf(File.pathSeparatorChar) != -1) {
            return path;
        }
        var = this.getBundle().getBundleContext().getProperty(var);
        if (var == null) {
            return path;
        }
        return path.substring(0, beginIndex - 1) + var + path.substring(endIndex + 1);
    }
}

