/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.WorkbenchCleaner;
import com.archimatetool.editor.actions.AboutHandler;
import com.archimatetool.editor.actions.ArchiActionFactory;
import com.archimatetool.editor.actions.CheckForNewVersionAction;
import com.archimatetool.editor.actions.ExportModelAction;
import com.archimatetool.editor.actions.ImportIntoModelAction;
import com.archimatetool.editor.actions.ImportModelAction;
import com.archimatetool.editor.actions.MRUMenuManager;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.actions.NewArchimateModelAction;
import com.archimatetool.editor.actions.OpenModelAction;
import com.archimatetool.editor.actions.ShowToolbarAction;
import com.archimatetool.editor.actions.WebBrowserAction;
import com.archimatetool.editor.ui.dialog.RelationshipsMatrixDialog;
import com.archimatetool.editor.utils.PlatformUtils;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.handlers.IHandlerService;

public class ArchiActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction fActionNewArchimateModel;
    private ActionFactory.IWorkbenchAction fActionOpenModel;
    private ActionFactory.IWorkbenchAction fActionOpenDiagram;
    private ActionFactory.IWorkbenchAction fActionCloseModel;
    private ActionFactory.IWorkbenchAction fActionCloseEditor;
    private ActionFactory.IWorkbenchAction fActionCloseAllEditors;
    private ActionFactory.IWorkbenchAction fActionSave;
    private ActionFactory.IWorkbenchAction fActionSaveAs;
    private ActionFactory.IWorkbenchAction fActionQuit;
    private ActionFactory.IWorkbenchAction fActionAbout;
    private ActionFactory.IWorkbenchAction fActionProperties;
    private ActionFactory.IWorkbenchAction fActionPrint;
    private ActionFactory.IWorkbenchAction fActionCut;
    private ActionFactory.IWorkbenchAction fActionCopy;
    private ActionFactory.IWorkbenchAction fActionPaste;
    private ActionFactory.IWorkbenchAction fActionPasteSpecial;
    private ActionFactory.IWorkbenchAction fActionDelete;
    private ActionFactory.IWorkbenchAction fActionRename;
    private ActionFactory.IWorkbenchAction fActionDuplicate;
    private ActionFactory.IWorkbenchAction fActionFindReplace;
    private ActionFactory.IWorkbenchAction fActionUndo;
    private ActionFactory.IWorkbenchAction fActionRedo;
    private ActionFactory.IWorkbenchAction fActionSelectAll;
    private ActionFactory.IWorkbenchAction fActionGenerateView;
    private ActionFactory.IWorkbenchAction fActionResetPerspective;
    private IAction fActionToggleCoolbar;
    private IAction fActionShowRelationsMatrix;
    private IAction fDonateAction;
    private IAction fActionCheckForNewVersion;
    private IAction fActionResetApplication;

    public ArchiActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.fActionOpenModel = new OpenModelAction(window);
        this.register((IAction)this.fActionOpenModel);
        this.fActionNewArchimateModel = new NewArchimateModelAction();
        this.register((IAction)this.fActionNewArchimateModel);
        this.fActionOpenDiagram = ArchiActionFactory.OPEN_DIAGRAM.create(window);
        this.register((IAction)this.fActionOpenDiagram);
        this.fActionCloseModel = ArchiActionFactory.CLOSE_MODEL.create(window);
        this.register((IAction)this.fActionCloseModel);
        this.fActionCloseEditor = ActionFactory.CLOSE.create(window);
        this.fActionCloseEditor.setText(Messages.ArchiActionBarAdvisor_0);
        this.register((IAction)this.fActionCloseEditor);
        this.fActionCloseAllEditors = ActionFactory.CLOSE_ALL.create(window);
        this.fActionCloseAllEditors.setText(Messages.ArchiActionBarAdvisor_1);
        this.register((IAction)this.fActionCloseAllEditors);
        this.fActionSave = ArchiActionFactory.SAVE_MODEL.create(window);
        this.register((IAction)this.fActionSave);
        this.fActionSaveAs = ArchiActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.fActionSaveAs);
        this.fActionProperties = ActionFactory.PROPERTIES.create(window);
        this.register((IAction)this.fActionProperties);
        this.fActionQuit = ActionFactory.QUIT.create(window);
        this.register((IAction)this.fActionQuit);
        this.fActionUndo = ActionFactory.UNDO.create(window);
        this.register((IAction)this.fActionUndo);
        this.fActionRedo = ActionFactory.REDO.create(window);
        this.register((IAction)this.fActionRedo);
        this.fActionCut = ActionFactory.CUT.create(window);
        this.register((IAction)this.fActionCut);
        this.fActionCopy = ActionFactory.COPY.create(window);
        this.register((IAction)this.fActionCopy);
        this.fActionPaste = ActionFactory.PASTE.create(window);
        this.register((IAction)this.fActionPaste);
        this.fActionPasteSpecial = ArchiActionFactory.PASTE_SPECIAL.create(window);
        this.register((IAction)this.fActionPasteSpecial);
        this.fActionDelete = ArchiActionFactory.DELETE.create(window);
        this.register((IAction)this.fActionDelete);
        this.fActionRename = ArchiActionFactory.RENAME.create(window);
        this.register((IAction)this.fActionRename);
        this.fActionDuplicate = ArchiActionFactory.DUPLICATE.create(window);
        this.register((IAction)this.fActionDuplicate);
        this.fActionSelectAll = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.fActionSelectAll);
        this.fActionFindReplace = ActionFactory.FIND.create(window);
        this.register((IAction)this.fActionFindReplace);
        this.fActionPrint = ActionFactory.PRINT.create(window);
        this.register((IAction)this.fActionPrint);
        this.fActionAbout = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.fActionAbout);
        IHandlerService srv = (IHandlerService)window.getService(IHandlerService.class);
        srv.activateHandler("org.eclipse.ui.help.aboutAction", (IHandler)new AboutHandler());
        this.fActionResetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.fActionResetPerspective.setText(Messages.ArchiActionBarAdvisor_2);
        this.register((IAction)this.fActionResetPerspective);
        this.fActionToggleCoolbar = new ShowToolbarAction();
        this.fActionShowRelationsMatrix = new Action(Messages.ArchiActionBarAdvisor_17){

            public void run() {
                RelationshipsMatrixDialog dialog = new RelationshipsMatrixDialog(window.getShell());
                dialog.open();
            }
        };
        this.fDonateAction = new WebBrowserAction(Messages.ArchiActionBarAdvisor_18, "https://www.archimatetool.com/donate");
        this.fActionCheckForNewVersion = new CheckForNewVersionAction();
        this.fActionResetApplication = new Action(Messages.ArchiActionBarAdvisor_20){

            public void run() {
                WorkbenchCleaner.askResetWorkbench();
            }
        };
        this.fActionGenerateView = ArchiActionFactory.GENERATE_VIEW.create(window);
        this.register((IAction)this.fActionGenerateView);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createToolsMenu());
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuManager menu = new MenuManager(Messages.ArchiActionBarAdvisor_8, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        MenuManager newMenu = new MenuManager(Messages.ArchiActionBarAdvisor_9, "new_menu");
        menu.add((IContributionItem)newMenu);
        newMenu.add((IAction)this.fActionNewArchimateModel);
        newMenu.add((IContributionItem)new GroupMarker("new_menu.ext"));
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IAction)this.fActionOpenModel);
        MRUMenuManager openRecentMenu = new MRUMenuManager(window);
        menu.add((IContributionItem)openRecentMenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionOpenDiagram);
        menu.add((IAction)this.fActionCloseModel);
        menu.add((IAction)this.fActionCloseEditor);
        menu.add((IAction)this.fActionCloseAllEditors);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionSave);
        menu.add((IAction)this.fActionSaveAs);
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionPrint);
        menu.add((IContributionItem)new Separator());
        MenuManager importMenu = new MenuManager(Messages.ArchiActionBarAdvisor_10, "import_menu");
        menu.add((IContributionItem)importMenu);
        this.addImportModelExtensionMenuItems(window, (IMenuManager)importMenu);
        importMenu.add((IContributionItem)new GroupMarker("import_ext"));
        importMenu.add((IContributionItem)new Separator());
        MenuManager exportMenu = new MenuManager(Messages.ArchiActionBarAdvisor_11, "export_menu");
        menu.add((IContributionItem)exportMenu);
        this.addExportModelExtensionMenuItems(window, (IMenuManager)exportMenu);
        exportMenu.add((IContributionItem)new GroupMarker("export_ext"));
        exportMenu.add((IContributionItem)new Separator());
        MenuManager reportMenu = new MenuManager(Messages.ArchiActionBarAdvisor_12, "report_menu");
        menu.add((IContributionItem)reportMenu);
        reportMenu.add((IContributionItem)new GroupMarker("report_ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionProperties);
        menu.add((IContributionItem)new Separator());
        if (!PlatformUtils.isMac()) {
            menu.add((IAction)this.fActionQuit);
        }
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuManager menu = new MenuManager(Messages.ArchiActionBarAdvisor_13, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.fActionUndo);
        menu.add((IAction)this.fActionRedo);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionCut);
        menu.add((IAction)this.fActionCopy);
        menu.add((IAction)this.fActionPaste);
        menu.add((IAction)this.fActionPasteSpecial);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fActionDelete);
        menu.add((IContributionItem)new Separator("cut.ext"));
        menu.add((IAction)this.fActionDuplicate);
        menu.add((IAction)this.fActionRename);
        menu.add((IContributionItem)new Separator(this.fActionRename.getId()));
        menu.add((IAction)this.fActionSelectAll);
        menu.add((IAction)this.fActionFindReplace);
        menu.add((IContributionItem)new Separator(this.fActionSelectAll.getId()));
        menu.add((IContributionItem)new GroupMarker("additions"));
        if (!PlatformUtils.isMac()) {
            menu.add((IContributionItem)new Separator());
            ActionFactory.IWorkbenchAction preferenceAction = ActionFactory.PREFERENCES.create(window);
            this.register((IAction)preferenceAction);
            menu.add((IAction)preferenceAction);
        }
        menu.add((IContributionItem)new Separator("editEnd"));
        return menu;
    }

    private MenuManager createToolsMenu() {
        MenuManager menu = new MenuManager(Messages.ArchiActionBarAdvisor_19, "tools");
        menu.add((IContributionItem)new GroupMarker("tools_start"));
        menu.add((IAction)this.fActionGenerateView);
        menu.add((IContributionItem)new GroupMarker("tools_end"));
        return menu;
    }

    private MenuManager createWindowMenu() {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuManager menu = new MenuManager(Messages.ArchiActionBarAdvisor_14, "window");
        menu.add((IContributionItem)new Separator("show_view_start"));
        menu.add((IContributionItem)new GroupMarker("show_view_append"));
        menu.add((IContributionItem)new Separator("show_view_end"));
        menu.add((IAction)this.fActionResetPerspective);
        menu.add(this.fActionToggleCoolbar);
        menu.add((IContributionItem)new Separator("nav_start"));
        MenuManager navigationMenu = new MenuManager(Messages.ArchiActionBarAdvisor_15);
        menu.add((IContributionItem)navigationMenu);
        ActionFactory.IWorkbenchAction a = ActionFactory.NEXT_EDITOR.create(window);
        a.setText(Messages.ArchiActionBarAdvisor_21);
        a.setToolTipText(Messages.ArchiActionBarAdvisor_22);
        this.register((IAction)a);
        navigationMenu.add((IAction)a);
        a = ActionFactory.PREVIOUS_EDITOR.create(window);
        a.setText(Messages.ArchiActionBarAdvisor_23);
        a.setToolTipText(Messages.ArchiActionBarAdvisor_24);
        this.register((IAction)a);
        navigationMenu.add((IAction)a);
        a = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        a.setText(Messages.ArchiActionBarAdvisor_25);
        a.setToolTipText(Messages.ArchiActionBarAdvisor_26);
        this.register((IAction)a);
        navigationMenu.add((IAction)a);
        navigationMenu.add((IContributionItem)new Separator());
        a = ActionFactory.NEXT_PART.create(window);
        a.setText(Messages.ArchiActionBarAdvisor_27);
        a.setToolTipText(Messages.ArchiActionBarAdvisor_28);
        this.register((IAction)a);
        navigationMenu.add((IAction)a);
        a = ActionFactory.PREVIOUS_PART.create(window);
        a.setText(Messages.ArchiActionBarAdvisor_29);
        a.setToolTipText(Messages.ArchiActionBarAdvisor_30);
        this.register((IAction)a);
        navigationMenu.add((IAction)a);
        menu.add((IContributionItem)new GroupMarker("nav_end"));
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createHelpMenu() {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        MenuManager menu = new MenuManager(Messages.ArchiActionBarAdvisor_16, "help");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IAction)ActionFactory.INTRO.create(window));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.HELP_CONTENTS.create(window));
        menu.add((IAction)ActionFactory.HELP_SEARCH.create(window));
        menu.add((IAction)ActionFactory.DYNAMIC_HELP.create(window));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("support_start"));
        menu.add(this.fDonateAction);
        menu.add(this.fActionCheckForNewVersion);
        menu.add((IContributionItem)new Separator("support_end"));
        menu.add(this.fActionResetApplication);
        menu.add((IContributionItem)new Separator());
        menu.add(this.fActionShowRelationsMatrix);
        if (!PlatformUtils.isMac()) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fActionAbout);
        }
        return menu;
    }

    protected void fillCoolBar(ICoolBarManager coolBarManager) {
        ToolBarManager toolBarFile = new ToolBarManager(0x800000);
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarFile, "toolbar_file"));
        toolBarFile.add((IContributionItem)new GroupMarker("start"));
        toolBarFile.add((IAction)this.fActionOpenModel);
        toolBarFile.add((IAction)this.fActionSave);
        toolBarFile.add((IContributionItem)new GroupMarker("end"));
        ToolBarManager toolBarEdit = new ToolBarManager(0x800000);
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarEdit, "toolbar_edit"));
        toolBarEdit.add((IContributionItem)new GroupMarker("start"));
        toolBarEdit.add((IAction)this.fActionUndo);
        toolBarEdit.add((IAction)this.fActionRedo);
        toolBarEdit.add((IContributionItem)new Separator());
        toolBarEdit.add((IAction)this.fActionCut);
        toolBarEdit.add((IAction)this.fActionCopy);
        toolBarEdit.add((IAction)this.fActionPaste);
        toolBarEdit.add((IAction)this.fActionDelete);
        toolBarEdit.add((IContributionItem)new GroupMarker("end"));
        ToolBarManager toolBarViews = new ToolBarManager(0x800000);
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarViews, "toolbar_views"));
        toolBarViews.add((IContributionItem)new GroupMarker("start"));
        toolBarViews.add((IContributionItem)new GroupMarker("append"));
        toolBarViews.add((IContributionItem)new GroupMarker("end"));
        toolBarViews.add((IContributionItem)new Separator());
        ToolBarManager toolBarTools = new ToolBarManager(0x800000);
        coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarTools, "toolbar_tools"));
    }

    private void addExportModelExtensionMenuItems(IWorkbenchWindow window, IMenuManager exportMenu) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.archimatetool.editor.exportHandler");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("id");
            String label = configurationElement.getAttribute("label");
            if (id != null && label != null) {
                exportMenu.add((IAction)new ExportModelAction(window, id, label));
            }
            ++n2;
        }
    }

    private void addImportModelExtensionMenuItems(IWorkbenchWindow window, IMenuManager importMenu) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.archimatetool.editor.importHandler");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String id = configurationElement.getAttribute("id");
            String label = configurationElement.getAttribute("label");
            if (id != null && label != null) {
                String extensionName = configurationElement.getName();
                if ("importHandler".equals(extensionName)) {
                    importMenu.add((IAction)new ImportModelAction(window, id, label));
                } else if ("importHandler2".equals(extensionName)) {
                    importMenu.add((IAction)new ImportIntoModelAction(window, id, label));
                }
            }
            ++n2;
        }
    }
}

