/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.utils.NetUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class CheckForNewVersionAction
extends Action {
    public CheckForNewVersionAction() {
        super(Messages.CheckForNewVersionAction_0);
    }

    String getOnlineVersion(URL url) throws IOException {
        int n;
        URLConnection connection = NetUtils.openConnection(url);
        connection.connect();
        InputStream is = connection.getInputStream();
        char[] buf = new char[32];
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        StringBuilder s = new StringBuilder();
        while ((n = r.read(buf)) >= 0) {
            s.append(buf, 0, n);
        }
        is.close();
        ((Reader)r).close();
        return s.toString();
    }

    public void run() {
        try {
            String thisVersion;
            String versionFile = ArchiPlugin.getInstance().getPreferenceStore().getString("updateURL");
            if (!StringUtils.isSet(versionFile)) {
                return;
            }
            String newVersion = this.getOnlineVersion(new URI(versionFile).toURL());
            if (StringUtils.compareVersionNumbers(newVersion, thisVersion = ArchiPlugin.getInstance().getVersion()) > 0) {
                IWorkbenchBrowserSupport support;
                IWebBrowser browser;
                String downloadURL = ArchiPlugin.getInstance().getPreferenceStore().getString("downloadURL");
                if (!StringUtils.isSet(downloadURL)) {
                    MessageDialog.openInformation(null, (String)Messages.CheckForNewVersionAction_1, (String)(Messages.CheckForNewVersionAction_2 + " (" + newVersion + "). "));
                    return;
                }
                boolean reply = MessageDialog.openQuestion(null, (String)Messages.CheckForNewVersionAction_1, (String)(Messages.CheckForNewVersionAction_2 + " (" + newVersion + "). " + Messages.CheckForNewVersionAction_3));
                if (reply && (browser = (support = PlatformUI.getWorkbench().getBrowserSupport()).getExternalBrowser()) != null) {
                    browser.openURL(new URI(downloadURL).toURL());
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.CheckForNewVersionAction_1, (String)Messages.CheckForNewVersionAction_4);
            }
        }
        catch (IOException | URISyntaxException ex) {
            ex.printStackTrace();
            this.showErrorMessage(Messages.CheckForNewVersionAction_5 + " " + ex.getMessage());
            return;
        }
        catch (PartInitException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isEnabled() {
        String versionFile = ArchiPlugin.getInstance().getPreferenceStore().getString("updateURL");
        return StringUtils.isSet(versionFile);
    }

    private void showErrorMessage(String message) {
        MessageDialog.openError(null, (String)Messages.CheckForNewVersionAction_6, (String)message);
    }
}

