/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.actions.AbstractModelAction;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.IModelExporter;
import com.archimatetool.model.IArchimateModel;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class ExportModelAction
extends AbstractModelAction {
    public ExportModelAction(IWorkbenchWindow window, String id, String label) {
        super(label, window);
        this.setId(id);
    }

    public void run() {
        IArchimateModel model = this.getActiveArchimateModel();
        if (model != null) {
            try {
                Object object = this.createExtensionPointInstance(this.getId());
                if (object instanceof IModelExporter) {
                    IModelExporter exporter = (IModelExporter)object;
                    exporter.export(model);
                }
            }
            catch (IOException | CoreException ex) {
                Logger.logError("Error on Export", ex);
                MessageDialog.openError((Shell)this.workbenchWindow.getShell(), (String)Messages.ExportModelAction_0, (String)ex.getMessage());
            }
        }
    }

    private Object createExtensionPointInstance(String extensionId) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.archimatetool.editor.exportHandler");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (Objects.equals(configurationElement.getAttribute("id"), extensionId)) {
                return configurationElement.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }
}

