/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.IModelImporter;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class ImportModelAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public ImportModelAction(IWorkbenchWindow window, String id, String label) {
        super(label);
        this.workbenchWindow = window;
        this.setId(id);
    }

    public void run() {
        try {
            Object object = this.createExtensionPointInstance(this.getId());
            if (object instanceof IModelImporter) {
                IModelImporter importer = (IModelImporter)object;
                importer.doImport();
            }
        }
        catch (IOException | CoreException ex) {
            Logger.logError("Error on Import", ex);
            MessageDialog.openError((Shell)this.workbenchWindow.getShell(), (String)Messages.ImportModelAction_0, (String)ex.getMessage());
        }
    }

    private Object createExtensionPointInstance(String extensionId) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.archimatetool.editor.importHandler");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (Objects.equals(configurationElement.getAttribute("id"), extensionId)) {
                return configurationElement.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
        this.workbenchWindow = null;
    }
}

