/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.views.IModelSelectionView;
import com.archimatetool.model.IArchimateModel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ModelSelectionHandler
implements IPartListener,
ISelectionChangedListener {
    private IWorkbenchWindow fWorkbenchWindow;
    private IWorkbenchPart fActivePart;
    private IModelSelectionHandlerListener fListener;

    public ModelSelectionHandler(IModelSelectionHandlerListener listener, IWorkbenchWindow workbenchWindow) {
        this.fListener = listener;
        this.fWorkbenchWindow = workbenchWindow;
        this.fWorkbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void refresh() {
        this.setActivePart(this.fWorkbenchWindow.getPartService().getActivePart());
    }

    public IArchimateModel getActiveArchimateModel() {
        return this.fActivePart != null ? (IArchimateModel)this.fActivePart.getAdapter(IArchimateModel.class) : null;
    }

    public void dispose() {
        this.fWorkbenchWindow.getPartService().removePartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setActivePart(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part instanceof IModelSelectionView) {
            ((IModelSelectionView)part).getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.fActivePart) {
            this.refresh();
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    private void setActivePart(IWorkbenchPart part) {
        if (part instanceof IModelSelectionView) {
            ((IModelSelectionView)part).getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fActivePart = part;
        this.fListener.updateState();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fListener.updateState();
    }

    public static interface IModelSelectionHandlerListener {
        public void updateState();
    }
}

