/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class OpenModelAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;

    public OpenModelAction(IWorkbenchWindow window) {
        this.window = window;
        this.setText(Messages.OpenModelAction_0);
        this.setToolTipText(Messages.OpenModelAction_1);
        this.setId("com.archimatetool.editor.action.openModel");
        this.setActionDefinitionId(this.getId());
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.window.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.archimate", "*.xml", "*.*"});
        String path = dialog.open();
        if (path != null) {
            final File file = new File(path);
            IArchimateModel model = this.getModel(file);
            if (model != null) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.OpenModelAction_2, (String)NLS.bind((String)Messages.OpenModelAction_3, (Object)file.getName(), (Object)model.getName()));
                return;
            }
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorModelManager.INSTANCE.openModel(file);
                }
            });
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return IArchiImages.ImageFactory.getImageDescriptor("img/open.png");
    }

    private IArchimateModel getModel(File file) {
        if (file != null) {
            for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
                if (!file.equals(model.getFile())) continue;
                return model;
            }
        }
        return null;
    }

    public void dispose() {
        this.window = null;
    }
}

