/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.actions.AbstractModelSelectionAction;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SaveAction
extends AbstractModelSelectionAction {
    private PropertyChangeListener commandStackListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == "IEditorModelManager.model.dirty") {
                SaveAction.this.updateState();
            }
        }
    };

    public SaveAction(IWorkbenchWindow window) {
        super(Messages.SaveAction_0, window);
        this.setActionDefinitionId("org.eclipse.ui.file.save");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        IEditorModelManager.INSTANCE.addPropertyChangeListener(this.commandStackListener);
    }

    public void run() {
        IArchimateModel model = this.getActiveArchimateModel();
        if (model != null) {
            try {
                IEditorModelManager.INSTANCE.saveModel(model);
            }
            catch (IOException ex) {
                MessageDialog.openError((Shell)this.workbenchWindow.getShell(), (String)Messages.SaveAction_1, (String)ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void updateState() {
        IArchimateModel model = this.getActiveArchimateModel();
        this.setEnabled(IEditorModelManager.INSTANCE.isModelDirty(model));
    }

    public void setEnabled(boolean enabled) {
        Shell shell;
        super.setEnabled(enabled);
        if (this.workbenchWindow != null && (shell = this.workbenchWindow.getShell()) != null && !shell.isDisposed()) {
            shell.setModified(enabled);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        IEditorModelManager.INSTANCE.removePropertyChangeListener(this.commandStackListener);
    }
}

