/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.model.commands.SetConceptTypeCommandFactory;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class SetConceptTypeExtensionContributionFactory
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        EClass eClass;
        EClass[] eClassArray;
        MenuManager subMenu;
        ISelectionService selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        IStructuredSelection selection = (IStructuredSelection)selectionService.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        HashSet<IArchimateElement> selectedElements = new HashSet<IArchimateElement>();
        HashSet<IArchimateRelationship> selectedRelations = new HashSet<IArchimateRelationship>();
        for (Object o : selection) {
            IArchimateElement element;
            IArchimateConcept concept = null;
            if (o instanceof IArchimateConcept) {
                concept = (IArchimateConcept)o;
            } else if (o instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)o;
                concept = (IArchimateConcept)adaptable.getAdapter(IArchimateConcept.class);
            }
            if (concept instanceof IArchimateElement && (element = (IArchimateElement)concept).eClass() != IArchimatePackage.eINSTANCE.getJunction()) {
                selectedElements.add(element);
                continue;
            }
            if (!(concept instanceof IArchimateRelationship)) continue;
            IArchimateRelationship relationship = (IArchimateRelationship)concept;
            selectedRelations.add(relationship);
        }
        if (selectedElements.isEmpty() && selectedRelations.isEmpty()) {
            return;
        }
        MenuManager menuManager = new MenuManager(Messages.SetConceptTypeExtensionContributionFactory_0);
        if (!selectedElements.isEmpty()) {
            subMenu = new MenuManager(FolderType.STRATEGY.getLabel());
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getStrategyClasses();
            int n = eClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(FolderType.BUSINESS.getLabel());
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getBusinessClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(FolderType.APPLICATION.getLabel());
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getApplicationClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(StringUtils.escapeAmpersandsInText(FolderType.TECHNOLOGY.getLabel()));
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getTechnologyClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu.add((IContributionItem)new Separator());
            eClassArray = ArchimateModelUtils.getPhysicalClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(FolderType.MOTIVATION.getLabel());
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getMotivationClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(StringUtils.escapeAmpersandsInText(FolderType.IMPLEMENTATION_MIGRATION.getLabel()));
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getImplementationMigrationClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
            subMenu = new MenuManager(FolderType.OTHER.getLabel());
            menuManager.add((IContributionItem)subMenu);
            eClassArray = ArchimateModelUtils.getOtherClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                subMenu.add(this.createElementTypeAction(eClass, selectedElements));
                ++n2;
            }
        }
        if (!selectedRelations.isEmpty()) {
            subMenu = menuManager;
            if (!selectedElements.isEmpty()) {
                subMenu = new MenuManager(Messages.SetConceptTypeExtensionContributionFactory_1);
                menuManager.add((IContributionItem)subMenu);
            }
            eClassArray = ArchimateModelUtils.getRelationsClasses();
            int n = eClassArray.length;
            int n3 = 0;
            while (n3 < n) {
                eClass = eClassArray[n3];
                subMenu.add(this.createRelationTypeAction(eClass, selectedRelations));
                ++n3;
            }
        }
        additions.addContributionItem((IContributionItem)menuManager, null);
    }

    private IAction createElementTypeAction(final EClass eClass, final Set<IArchimateElement> elements) {
        Action action = new Action(ArchiLabelProvider.INSTANCE.getDefaultName(eClass)){

            public void run() {
                boolean hasInvalidConnections = false;
                for (IArchimateElement element : elements) {
                    if (SetConceptTypeCommandFactory.isValidTypeForElement(eClass, element, elements)) continue;
                    hasInvalidConnections = true;
                }
                if (hasInvalidConnections && !MessageDialog.openConfirm(null, (String)Messages.SetConceptTypeExtensionContributionFactory_0, (String)Messages.SetConceptTypeExtensionContributionFactory_2)) {
                    return;
                }
                SetConceptTypeExtensionContributionFactory.this.changeElementTypes(eClass, elements);
            }
        };
        action.setEnabled(false);
        for (IArchimateElement element : elements) {
            if (element.eClass() == eClass) continue;
            action.setEnabled(true);
        }
        action.setImageDescriptor(ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass));
        return action;
    }

    private IAction createRelationTypeAction(final EClass eClass, final Set<IArchimateRelationship> relations) {
        Action action = new Action(ArchiLabelProvider.INSTANCE.getDefaultName(eClass)){

            public void run() {
                SetConceptTypeExtensionContributionFactory.this.changeRelationTypes(eClass, relations);
            }
        };
        action.setEnabled(false);
        for (IArchimateRelationship relation : relations) {
            if (relation.eClass() == eClass || !SetConceptTypeCommandFactory.isValidTypeForRelationship(eClass, relation)) continue;
            action.setEnabled(true);
        }
        action.setImageDescriptor(ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass));
        return action;
    }

    private void changeElementTypes(EClass eClass, Set<IArchimateElement> elements) {
        Map<IArchimateModel, Set<IArchimateElement>> elementsMap = this.getConceptMap(elements);
        for (Map.Entry<IArchimateModel, Set<IArchimateElement>> entry : elementsMap.entrySet()) {
            CommandStack stack = (CommandStack)entry.getKey().getAdapter(CommandStack.class);
            CompoundCommand cmd = SetConceptTypeCommandFactory.createSetElementTypeCommand(eClass, entry.getValue(), ArchiPlugin.getInstance().getPreferenceStore().getBoolean("addDocumentationNoteOnRelationChange"));
            if (stack == null || cmd == null) continue;
            stack.execute((Command)new NonNotifyingCompoundCommand(new Command[]{cmd}));
        }
    }

    private void changeRelationTypes(EClass eClass, Set<IArchimateRelationship> relations) {
        Map<IArchimateModel, Set<IArchimateRelationship>> relationsMap = this.getConceptMap(relations);
        for (Map.Entry<IArchimateModel, Set<IArchimateRelationship>> entry : relationsMap.entrySet()) {
            CommandStack stack = (CommandStack)entry.getKey().getAdapter(CommandStack.class);
            CompoundCommand cmd = SetConceptTypeCommandFactory.createSetRelationTypeCommand(eClass, entry.getValue());
            if (stack == null || cmd == null) continue;
            stack.execute((Command)new NonNotifyingCompoundCommand(new Command[]{cmd}));
        }
    }

    private <T extends IArchimateConcept> Map<IArchimateModel, Set<T>> getConceptMap(Set<T> concepts) {
        HashMap<IArchimateModel, Set<T>> map = new HashMap<IArchimateModel, Set<T>>();
        for (IArchimateConcept concept : concepts) {
            HashSet<IArchimateConcept> elementsSet = (HashSet<IArchimateConcept>)map.get(concept.getArchimateModel());
            if (elementsSet == null) {
                elementsSet = new HashSet<IArchimateConcept>();
                map.put(concept.getArchimateModel(), elementsSet);
            }
            elementsSet.add(concept);
        }
        return map;
    }
}

