/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.AbstractPaletteRoot;
import com.archimatetool.editor.diagram.DiagramEditorFindReplaceProvider;
import com.archimatetool.editor.diagram.DiagramEditorInput;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.NullDiagramEditorInput;
import com.archimatetool.editor.diagram.OverviewOutlinePage;
import com.archimatetool.editor.diagram.actions.BorderColorAction;
import com.archimatetool.editor.diagram.actions.ConnectionRouterAction;
import com.archimatetool.editor.diagram.actions.CopyAction;
import com.archimatetool.editor.diagram.actions.CutAction;
import com.archimatetool.editor.diagram.actions.DefaultEditPartSizeAction;
import com.archimatetool.editor.diagram.actions.DeleteContainerAction;
import com.archimatetool.editor.diagram.actions.ExportAsImageAction;
import com.archimatetool.editor.diagram.actions.ExportAsImageToClipboardAction;
import com.archimatetool.editor.diagram.actions.FillColorAction;
import com.archimatetool.editor.diagram.actions.FindReplaceAction;
import com.archimatetool.editor.diagram.actions.FontAction;
import com.archimatetool.editor.diagram.actions.FontColorAction;
import com.archimatetool.editor.diagram.actions.FullScreenAction;
import com.archimatetool.editor.diagram.actions.LineColorAction;
import com.archimatetool.editor.diagram.actions.LineWidthAction;
import com.archimatetool.editor.diagram.actions.LockObjectAction;
import com.archimatetool.editor.diagram.actions.ObjectPositionAction;
import com.archimatetool.editor.diagram.actions.OpacityAction;
import com.archimatetool.editor.diagram.actions.OutlineOpacityAction;
import com.archimatetool.editor.diagram.actions.PasteAction;
import com.archimatetool.editor.diagram.actions.PasteSpecialAction;
import com.archimatetool.editor.diagram.actions.PrintDiagramAction;
import com.archimatetool.editor.diagram.actions.PropertiesAction;
import com.archimatetool.editor.diagram.actions.ResetAspectRatioAction;
import com.archimatetool.editor.diagram.actions.SelectAllAction;
import com.archimatetool.editor.diagram.actions.SelectElementInTreeAction;
import com.archimatetool.editor.diagram.actions.SelectSameObjectTypeAction;
import com.archimatetool.editor.diagram.actions.TextAlignmentAction;
import com.archimatetool.editor.diagram.actions.TextPositionAction;
import com.archimatetool.editor.diagram.actions.ToggleGridEnabledAction;
import com.archimatetool.editor.diagram.actions.ToggleGridVisibleAction;
import com.archimatetool.editor.diagram.actions.ToggleSnapToAlignmentGuidesAction;
import com.archimatetool.editor.diagram.actions.ZoomNormalAction;
import com.archimatetool.editor.diagram.dnd.PaletteTemplateTransferDropTargetListener;
import com.archimatetool.editor.diagram.figures.ITextFigure;
import com.archimatetool.editor.diagram.tools.FormatPainterInfo;
import com.archimatetool.editor.diagram.tools.FormatPainterToolEntry;
import com.archimatetool.editor.diagram.tools.MouseWheelHorizontalScrollHandler;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.findreplace.IFindReplaceProvider;
import com.archimatetool.editor.ui.services.ComponentSelectionManager;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.util.LightweightAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.internal.InternalGEFPlugin;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchSizeAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements IDiagramModelEditor,
IContextProvider,
ITabbedPropertySheetPageContributor {
    private Composite fErrorComposite;
    private NullDiagramEditorInput fNullInput;
    protected IDiagramModel fDiagramModel;
    protected List<UpdateAction> fUpdateCommandStackActions = new ArrayList<UpdateAction>();
    protected IPropertyChangeListener appPreferencesListener = this::applicationPreferencesChanged;
    private LightweightAdapter eCoreAdapter = new LightweightAdapter(this::notifyChanged);
    private DiagramEditorFindReplaceProvider fFindReplaceProvider;
    protected AbstractPaletteRoot fPaletteRoot;
    private IContextActivation fContextActivation;

    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("gridSize" == event.getProperty()) {
            this.applyUserGridPreferences();
        } else if ("gridVisible" == event.getProperty()) {
            this.applyUserGridPreferences();
        } else if ("gridSnap" == event.getProperty()) {
            this.applyUserGridPreferences();
        } else if ("gridShowGuidelines" == event.getProperty()) {
            this.applyUserGridPreferences();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof NullDiagramEditorInput) {
            this.fNullInput = (NullDiagramEditorInput)input;
            super.setSite((IWorkbenchPartSite)site);
            super.setInput(input);
            this.setPartName(input.getName());
        } else {
            super.init(site, input);
            this.activateContext();
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.fDiagramModel = ((DiagramEditorInput)input).getDiagramModel();
        this.eCoreAdapter.add(new EObject[]{this.fDiagramModel, this.fDiagramModel.getArchimateModel()});
        DefaultEditDomain domain = new DefaultEditDomain(this){
            private CommandStack stack;

            public CommandStack getCommandStack() {
                if (this.stack == null) {
                    this.stack = (CommandStack)AbstractDiagramEditor.this.fDiagramModel.getAdapter(CommandStack.class);
                }
                return this.stack;
            }
        };
        this.setEditDomain(domain);
        this.setPartName(input.getName());
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.appPreferencesListener);
    }

    public void createPartControl(Composite parent) {
        if (this.fNullInput != null) {
            this.createErrorComposite(parent);
        } else {
            super.createPartControl(parent);
            this.doCreatePartControl(parent);
        }
    }

    protected void createErrorComposite(Composite parent) {
        this.fErrorComposite = new Composite(parent, 0);
        this.fErrorComposite.setLayout((Layout)new GridLayout());
        this.fErrorComposite.setLayoutData((Object)new GridData(1808));
        String errorMessage = Messages.AbstractDiagramEditor_0 + " ";
        String fileName = this.fNullInput.getFileName();
        if (fileName != null) {
            errorMessage = !new File(fileName).exists() ? errorMessage + NLS.bind((String)Messages.AbstractDiagramEditor_1, (Object)fileName) : errorMessage + NLS.bind((String)Messages.AbstractDiagramEditor_3, (Object)fileName);
        }
        CLabel imageLabel = new CLabel(this.fErrorComposite, 0);
        imageLabel.setImage(Display.getDefault().getSystemImage(2));
        imageLabel.setText(errorMessage);
    }

    @Override
    public IDiagramModel getModel() {
        return this.fDiagramModel;
    }

    protected abstract void doCreatePartControl(Composite var1);

    protected abstract void registerContextMenu(GraphicalViewer var1);

    protected void createRootEditPart(GraphicalViewer viewer) {
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart(false));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        this.registerContextMenu(viewer);
        this.createRootEditPart(viewer);
        this.createActions(viewer);
        viewer.addDropTargetListener((TransferDropTargetListener)new PaletteTemplateTransferDropTargetListener(this));
        this.setProperties();
        this.hookSelectionListener();
        ThemeUtils.registerCssId(viewer.getControl(), "ArchiFigureCanvas");
        ThemeUtils.setBackgroundColorIfCssThemingDisabled(viewer.getControl(), "com.archimatetool.editor.VIEW_BACKGROUND");
    }

    private void hookSelectionListener() {
        this.getGraphicalViewer().addSelectionChangedListener(event -> this.updateStatusBarWithSelection(event.getStructuredSelection().isEmpty() ? null : event.getStructuredSelection().toList().getLast()));
    }

    public void setFocus() {
        if (this.fNullInput != null) {
            this.fErrorComposite.setFocus();
        } else {
            super.setFocus();
            this.updateShellTitleBarWithFileName();
        }
    }

    protected void updateStatusBarWithSelection(Object selected) {
        IStatusLineManager status = this.getEditorSite().getActionBars().getStatusLineManager();
        if (selected instanceof EditPart) {
            EditPart editPart = (EditPart)selected;
            selected = editPart.getModel();
            Image image = ArchiLabelProvider.INSTANCE.getImage(selected);
            String text = ArchiLabelProvider.INSTANCE.getLabelNormalised(selected);
            status.setMessage(image, text);
        } else {
            status.setMessage(null, "");
        }
    }

    protected void updateShellTitleBarWithFileName() {
        String appname = ArchiPlugin.getInstance().getProductName();
        File file = this.getModel().getArchimateModel().getFile();
        if (file != null) {
            this.getEditorSite().getShell().setText(appname + " - " + file.getPath());
        } else {
            this.getEditorSite().getShell().setText(appname);
        }
    }

    @Override
    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected DefaultEditDomain getEditDomain() {
        if (this.fNullInput != null) {
            return new DefaultEditDomain((IEditorPart)this);
        }
        return super.getEditDomain();
    }

    protected void setProperties() {
        this.applyUserGridPreferences();
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), (Object)MouseWheelHorizontalScrollHandler.SINGLETON);
    }

    protected void applyUserGridPreferences() {
        IPreferenceStore store = ArchiPlugin.getInstance().getPreferenceStore();
        int gridSize = store.getInt("gridSize");
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSize, gridSize));
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)store.getBoolean("gridVisible"));
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)store.getBoolean("gridSnap"));
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)store.getBoolean("gridShowGuidelines"));
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        boolean showPalette = ArchiPlugin.getInstance().getPreferenceStore().getBoolean("palette_state");
        this.getPalettePreferences().setPaletteState(showPalette ? 4 : 2);
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void hookPaletteViewer(PaletteViewer viewer) {
                super.hookPaletteViewer(viewer);
                AbstractDiagramEditor.this.configurePaletteViewer(viewer);
            }
        };
    }

    protected void configurePaletteViewer(final PaletteViewer viewer) {
        PaletteViewerPreferences prefs = viewer.getPaletteViewerPreferences();
        prefs.setUseLargeIcons(2, false);
        prefs.setUseLargeIcons(1, false);
        prefs.setUseLargeIcons(3, false);
        prefs.setUseLargeIcons(0, false);
        if (!InternalGEFPlugin.getDefault().getPreferenceStore().getBoolean("com.archimatetool.paletteSet")) {
            InternalGEFPlugin.getDefault().getPreferenceStore().setValue("com.archimatetool.paletteSet", true);
            prefs.setLayoutSetting(2);
            prefs.setCurrentUseLargeIcons(false);
        }
        viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
        viewer.addPaletteListener(new PaletteListener(){

            public void activeToolChanged(PaletteViewer palette, ToolEntry toolEntry) {
                CreationFactory factory = (CreationFactory)toolEntry.getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY);
                if (factory != null) {
                    ComponentSelectionManager.INSTANCE.fireSelectionEvent(toolEntry, factory.getObjectType());
                }
            }
        });
        viewer.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                CreationFactory factory;
                ToolEntry toolEntry = AbstractDiagramEditor.this.findToolEntryAt(viewer, new Point(e.x, e.y));
                if (toolEntry != null && (factory = (CreationFactory)toolEntry.getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY)) != null) {
                    ComponentSelectionManager.INSTANCE.fireSelectionEvent(toolEntry, factory.getObjectType());
                }
            }
        });
        viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolEntry toolEntry = AbstractDiagramEditor.this.findToolEntryAt(viewer, new Point(e.x, e.y));
                if (toolEntry instanceof CreationToolEntry) {
                    boolean shiftKey = (e.stateMask & 0x20000) != 0;
                    toolEntry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, (Object)(!shiftKey ? 1 : 0));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                ToolEntry toolEntry = AbstractDiagramEditor.this.findToolEntryAt(viewer, new Point(e.x, e.y));
                if (toolEntry instanceof FormatPainterToolEntry) {
                    FormatPainterInfo.INSTANCE.reset();
                } else if (toolEntry instanceof CreationToolEntry) {
                    toolEntry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, (Object)false);
                }
            }
        });
    }

    private ToolEntry findToolEntryAt(PaletteViewer viewer, Point pt) {
        EditPart ep = viewer.findObjectAt(pt);
        if (ep != null && ep.getModel() instanceof ToolEntry) {
            return (ToolEntry)ep.getModel();
        }
        return null;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.updateCommandStackActions();
        this.setDirty(this.getCommandStack().isDirty());
        this.refreshFiguresWithLabelFeature();
    }

    protected void updateCommandStackActions() {
        if (this.equals(this.getSite().getPage().getActiveEditor())) {
            for (UpdateAction action : this.getUpdateCommandStackActions()) {
                action.update();
            }
        }
    }

    protected List<UpdateAction> getUpdateCommandStackActions() {
        return this.fUpdateCommandStackActions;
    }

    protected void refreshFiguresWithLabelFeature() {
        for (Object editPart : this.getGraphicalViewer().getEditPartRegistry().values()) {
            if (!(editPart instanceof GraphicalEditPart)) continue;
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            Object model = ((GraphicalEditPart)editPart).getModel();
            if (!(model instanceof IDiagramModelComponent) || !TextRenderer.getDefault().hasFormatExpression((IArchimateModelObject)((IDiagramModelComponent)model)) || !(figure instanceof ITextFigure)) continue;
            ((ITextFigure)figure).setText();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setDirty(boolean dirty) {
        this.firePropertyChange(257);
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    protected void createActions(GraphicalViewer viewer) {
        ActionRegistry registry = this.getActionRegistry();
        ZoomManager zoomManager = this.getAdapter(ZoomManager.class);
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0};
        zoomManager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributionLevels = new ArrayList<String>();
        zoomContributionLevels.add(ZoomManager.FIT_ALL);
        zoomContributionLevels.add(ZoomManager.FIT_WIDTH);
        zoomContributionLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomContributionLevels);
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        ZoomNormalAction zoomNormal = new ZoomNormalAction(zoomManager);
        registry.registerAction((IAction)zoomIn);
        registry.registerAction((IAction)zoomOut);
        registry.registerAction((IAction)zoomNormal);
        IHandlerService service = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        service.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        service.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
        service.activateHandler(zoomNormal.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomNormal));
        Object action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new PrintDiagramAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new DirectEditAction((IEditorPart)this);
        action.setId(ActionFactory.RENAME.getId());
        action.setText(Messages.AbstractDiagramEditor_4);
        action.setToolTipText(Messages.AbstractDiagramEditor_13);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = registry.getAction((Object)ActionFactory.DELETE.getId());
        action.setText(Messages.AbstractDiagramEditor_2);
        action.setToolTipText(action.getText());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new DeleteContainerAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        PasteAction pasteAction = new PasteAction((IWorkbenchPart)this, viewer);
        registry.registerAction((IAction)pasteAction);
        this.getSelectionActions().add(pasteAction.getId());
        PasteSpecialAction pasteSpecialAction = new PasteSpecialAction((IWorkbenchPart)this, viewer);
        registry.registerAction((IAction)pasteSpecialAction);
        this.getSelectionActions().add(pasteSpecialAction.getId());
        action = new CutAction((IWorkbenchPart)this, pasteAction);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new CopyAction((IWorkbenchPart)this, pasteAction);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new ToggleGridEnabledAction();
        registry.registerAction((IAction)action);
        action = new ToggleGridVisibleAction();
        registry.registerAction((IAction)action);
        action = new ToggleSnapToAlignmentGuidesAction();
        registry.registerAction((IAction)action);
        action = new MatchWidthAction((IWorkbenchPart)this);
        action.setText(Messages.AbstractDiagramEditor_5);
        action.setToolTipText(Messages.AbstractDiagramEditor_14);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MatchHeightAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action.setText(Messages.AbstractDiagramEditor_6);
        action.setToolTipText(Messages.AbstractDiagramEditor_15);
        this.getSelectionActions().add(action.getId());
        action = new MatchSizeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action.setText(Messages.AbstractDiagramEditor_22);
        action.setToolTipText(Messages.AbstractDiagramEditor_23);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        action.setText(Messages.AbstractDiagramEditor_7);
        action.setToolTipText(Messages.AbstractDiagramEditor_16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        action.setText(Messages.AbstractDiagramEditor_8);
        action.setToolTipText(Messages.AbstractDiagramEditor_17);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        action.setText(Messages.AbstractDiagramEditor_9);
        action.setToolTipText(Messages.AbstractDiagramEditor_18);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        action.setText(Messages.AbstractDiagramEditor_10);
        action.setToolTipText(Messages.AbstractDiagramEditor_19);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        action.setText(Messages.AbstractDiagramEditor_11);
        action.setToolTipText(Messages.AbstractDiagramEditor_20);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        action.setText(Messages.AbstractDiagramEditor_12);
        action.setToolTipText(Messages.AbstractDiagramEditor_21);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DefaultEditPartSizeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new ResetAspectRatioAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new PropertiesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new FillColorAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new LineWidthAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new LineColorAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new FontAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new FontColorAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new OpacityAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new OutlineOpacityAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new ExportAsImageAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ExportAsImageToClipboardAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ConnectionRouterAction.BendPointConnectionRouterAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ConnectionRouterAction.ManhattanConnectionRouterAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        for (ObjectPositionAction objectPositionAction : ObjectPositionAction.createActions((IWorkbenchPart)this)) {
            registry.registerAction((IAction)objectPositionAction);
            this.getSelectionActions().add(objectPositionAction.getId());
            this.getUpdateCommandStackActions().add((UpdateAction)objectPositionAction);
        }
        for (TextAlignmentAction textAlignmentAction : TextAlignmentAction.createActions((IWorkbenchPart)this)) {
            registry.registerAction((IAction)textAlignmentAction);
            this.getSelectionActions().add(textAlignmentAction.getId());
            this.getUpdateCommandStackActions().add((UpdateAction)textAlignmentAction);
        }
        for (TextPositionAction textPositionAction : TextPositionAction.createActions((IWorkbenchPart)this)) {
            registry.registerAction((IAction)textPositionAction);
            this.getSelectionActions().add(textPositionAction.getId());
            this.getUpdateCommandStackActions().add((UpdateAction)textPositionAction);
        }
        action = new LockObjectAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        action = new BorderColorAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getUpdateCommandStackActions().add((UpdateAction)action);
        if (!PlatformUtils.isMac()) {
            action = new FullScreenAction((IWorkbenchPart)this);
            registry.registerAction((IAction)action);
        }
        action = new SelectElementInTreeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SelectSameObjectTypeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new FindReplaceAction(this.getEditorSite().getWorkbenchWindow());
        registry.registerAction((IAction)action);
    }

    protected void disableActions() {
        Iterator actions = this.getActionRegistry().getActions();
        while (actions.hasNext()) {
            IAction action = (IAction)actions.next();
            action.setEnabled(false);
        }
    }

    public IContextActivation activateContext() {
        if (this.fContextActivation == null) {
            this.fContextActivation = ((IContextService)this.getSite().getService(IContextService.class)).activateContext("com.archimatetool.editor.diagram.context");
        }
        return this.fContextActivation;
    }

    public void deactivateContext() {
        if (this.fContextActivation != null) {
            this.fContextActivation.getContextService().deactivateContext(this.fContextActivation);
            this.fContextActivation = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectObjects(Object[] objects) {
        void var4_7;
        if (this.getGraphicalViewer() == null || this.getGraphicalViewer().getControl() == null || this.getModel() == null) {
            return;
        }
        HashSet<Object> selection = new HashSet<Object>();
        Object[] objectArray = objects;
        int n = objects.length;
        boolean n2 = false;
        while (var4_7 < n) {
            Object object = objectArray[var4_7];
            if (object instanceof IDiagramModel) {
                for (IDiagramModelComponent iDiagramModelComponent : DiagramModelUtils.findDiagramModelReferences((IDiagramModelContainer)this.getModel(), (IDiagramModel)object)) {
                    selection.add(iDiagramModelComponent);
                }
            } else {
                selection.add(object);
            }
            ++var4_7;
        }
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (Object e : selection) {
            EditPart editPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(e);
            if (editPart == null || !editPart.isSelectable() || editParts.contains(editPart)) continue;
            editParts.add(editPart);
        }
        if (!editParts.isEmpty()) {
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(editParts));
            this.getGraphicalViewer().reveal((EditPart)editParts.get(0));
        } else {
            this.getGraphicalViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public String getContributorId() {
        return "com.archimatetool.editor";
    }

    public <T> T getAdapter(Class<T> adapter) {
        RootEditPart rootEditPart;
        if (adapter == ZoomManager.class && this.getGraphicalViewer() != null) {
            return adapter.cast(this.getGraphicalViewer().getProperty(ZoomManager.class.toString()));
        }
        if (adapter == IContentOutlinePage.class && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart editPart = (ScalableFreeformRootEditPart)rootEditPart;
            return adapter.cast((Object)new OverviewOutlinePage(editPart));
        }
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IArchimateModel.class && this.getModel() != null) {
            return adapter.cast(this.getModel().getArchimateModel());
        }
        if (adapter == IDiagramModel.class) {
            return adapter.cast(this.getModel());
        }
        if (adapter == IFindReplaceProvider.class) {
            if (this.fFindReplaceProvider == null && this.getGraphicalViewer() != null) {
                this.fFindReplaceProvider = new DiagramEditorFindReplaceProvider(this.getGraphicalViewer());
            }
            return adapter.cast(this.fFindReplaceProvider);
        }
        return (T)super.getAdapter(adapter);
    }

    protected void notifyChanged(Notification msg) {
        if (msg.getFeature() == IArchimatePackage.Literals.NAMEABLE__NAME) {
            this.setPartName(this.getEditorInput().getName());
        }
    }

    public void dispose() {
        int openEditors;
        super.dispose();
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.appPreferencesListener);
        this.eCoreAdapter.remove(new EObject[]{this.getModel(), this.getModel() != null ? this.getModel().getArchimateModel() : null});
        this.getSite().getShell().setText(ArchiPlugin.getInstance().getProductName());
        this.disableActions();
        if (this.getEditorInput() instanceof DiagramEditorInput && (openEditors = EditorManager.getDiagramEditorReferences(this.fDiagramModel).length) == 0) {
            ((DiagramEditorInput)this.getEditorInput()).dispose();
        }
        if (this.fPaletteRoot != null) {
            this.fPaletteRoot.dispose();
        }
        this.fDiagramModel = null;
        this.fContextActivation = null;
        this.fFindReplaceProvider = null;
    }
}

