/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IImageExportProvider;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.ui.ImageFactory;
import java.io.File;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class ImageExportProvider
implements IImageExportProvider {
    public static final String BMP_IMAGE_EXPORT_PROVIDER = "com.archimatetool.editor.bmpImageExportProvider";
    public static final String JPEG_IMAGE_EXPORT_PROVIDER = "com.archimatetool.editor.jpegImageExportProvider";
    public static final String PNG_IMAGE_EXPORT_PROVIDER = "com.archimatetool.editor.pngImageExportProvider";
    static final String PREFS_IMAGE_SCALE = "imageExportScale";
    private IFigure fFigure;
    protected Spinner fScaleSpinner;
    private static final int SCALE_MIN = 25;
    private static final int SCALE_MAX = 400;

    @Override
    public void export(String providerID, File file) throws Exception {
        Image image = null;
        try {
            image = DiagramUtils.createImage(this.fFigure, (double)this.fScaleSpinner.getSelection() / 100.0, 10);
            ImageData imageData = image.getImageData(ImageFactory.getImageDeviceZoom());
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{imageData};
            if (BMP_IMAGE_EXPORT_PROVIDER.equals(providerID)) {
                loader.save(file.getPath(), 0);
            } else if (JPEG_IMAGE_EXPORT_PROVIDER.equals(providerID)) {
                loader.save(file.getPath(), 4);
            } else if (PNG_IMAGE_EXPORT_PROVIDER.equals(providerID)) {
                loader.save(file.getPath(), 5);
            } else {
                loader.save(file.getPath() + ".png", 5);
            }
        }
        finally {
            this.savePreferences();
            if (image != null) {
                image.dispose();
            }
        }
    }

    @Override
    public void init(IImageExportProvider.IExportDialogAdapter adapter, Composite container, IFigure figure) {
        this.fFigure = figure;
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 0);
        label.setText(Messages.ImageExportProvider_0);
        this.fScaleSpinner = new Spinner(container, 2048);
        this.fScaleSpinner.setMinimum(25);
        this.fScaleSpinner.setMaximum(400);
        this.loadPreferences();
    }

    protected void loadPreferences() {
        int scale = ArchiPlugin.getInstance().getPreferenceStore().getInt(PREFS_IMAGE_SCALE);
        if (scale < 25 || scale > 400) {
            scale = 100;
        }
        this.fScaleSpinner.setSelection(scale);
    }

    protected void savePreferences() {
        int scale = this.fScaleSpinner.getSelection();
        ArchiPlugin.getInstance().getPreferenceStore().setValue(PREFS_IMAGE_SCALE, scale);
    }
}

