/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.diagram.IImageExportProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ImageExportProviderManager {
    private static List<ImageExportProviderInfo> imageProviders;

    public static List<ImageExportProviderInfo> getImageExportProviders() {
        if (imageProviders == null) {
            ImageExportProviderManager.registerImageExportProviders();
            Collections.sort(imageProviders, new Comparator<ImageExportProviderInfo>(){

                @Override
                public int compare(ImageExportProviderInfo p1, ImageExportProviderInfo p2) {
                    return p1.getLabel().compareTo(p2.getLabel());
                }
            });
        }
        return new ArrayList<ImageExportProviderInfo>(imageProviders);
    }

    private static void registerImageExportProviders() {
        imageProviders = new ArrayList<ImageExportProviderInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.archimatetool.editor.imageExportProvider");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String id = configurationElement.getAttribute("id");
                String label = configurationElement.getAttribute("label");
                String extensions = configurationElement.getAttribute("extensions");
                IImageExportProvider provider = (IImageExportProvider)configurationElement.createExecutableExtension("class");
                if (id != null && label != null && provider != null) {
                    ImageExportProviderInfo providerInfo = new ImageExportProviderInfo(provider, id, label, extensions);
                    imageProviders.add(providerInfo);
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public static class ImageExportProviderInfo {
        private IImageExportProvider provider;
        private String id;
        private String label;
        private List<String> extensions;

        public ImageExportProviderInfo(IImageExportProvider provider, String id, String label, String extensions) {
            this.provider = provider;
            this.id = id;
            this.label = label;
            extensions = extensions.replace(" ", "");
            this.extensions = Arrays.asList(extensions.split(","));
        }

        public IImageExportProvider getProvider() {
            return this.provider;
        }

        public String getID() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [id: " + this.id + ", name: " + this.label + "]";
        }
    }
}

