/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.keys.IBindingService;

public class PaletteKeyHandler
extends AbstractHandler
implements IParameterValues {
    public static final String COMMAND_ID = "com.archimatetool.editor.palette.command";
    public static final String PARAMETER_ID = "com.archimatetool.editor.palette.command.params";
    public static final String KEY_BINDING = "keyBinding";
    private static Map<String, String> paramValues;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart iEditorPart;
        String parameterValue = event.getParameter(PARAMETER_ID);
        if (parameterValue != null && (iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event)) instanceof IDiagramModelEditor) {
            IDiagramModelEditor editor = (IDiagramModelEditor)iEditorPart;
            PaletteViewer paletteViewer = editor.getGraphicalViewer().getEditDomain().getPaletteViewer();
            for (Object rootEntry : paletteViewer.getPaletteRoot().getChildren()) {
                if (!(rootEntry instanceof PaletteContainer)) continue;
                PaletteContainer container = (PaletteContainer)rootEntry;
                for (Object childEntry : container.getChildren()) {
                    ToolEntry toolEntry;
                    String keyName;
                    if (!(childEntry instanceof ToolEntry) || !parameterValue.equals(keyName = (String)(toolEntry = (ToolEntry)childEntry).getToolProperty((Object)KEY_BINDING))) continue;
                    if (toolEntry != paletteViewer.getActiveTool()) {
                        paletteViewer.setActiveTool(toolEntry);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public Map<String, String> getParameterValues() {
        if (paramValues == null) {
            EClass eClass;
            paramValues = new HashMap<String, String>();
            EClass[] eClassArray = ArchimateModelUtils.getAllArchimateClasses();
            int n = eClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), eClass.getName());
                ++n2;
            }
            eClassArray = ArchimateModelUtils.getRelationsClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), eClass.getName());
                ++n2;
            }
            eClassArray = ArchimateModelUtils.getConnectorClasses();
            n = eClassArray.length;
            n2 = 0;
            while (n2 < n) {
                eClass = eClassArray[n2];
                paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), eClass.getName());
                ++n2;
            }
            paramValues.put(Messages.ArchimateDiagramEditorPalette_14, "MagicConnector");
            paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(IArchimatePackage.eINSTANCE.getDiagramModelNote()), IArchimatePackage.eINSTANCE.getDiagramModelNote().getName());
            paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(IArchimatePackage.eINSTANCE.getDiagramModelGroup()), IArchimatePackage.eINSTANCE.getDiagramModelGroup().getName());
            paramValues.put(ArchiLabelProvider.INSTANCE.getDefaultName(IArchimatePackage.eINSTANCE.getDiagramModelConnection()), IArchimatePackage.eINSTANCE.getDiagramModelConnection().getName());
        }
        return paramValues;
    }

    public static void setKeyBinding(ToolEntry toolEntry, String parameterValue) {
        toolEntry.setToolProperty((Object)KEY_BINDING, (Object)parameterValue);
        String acceleratorText = PaletteKeyHandler.getAcceleratorText(parameterValue);
        if (acceleratorText != null) {
            toolEntry.setDescription(StringUtils.safeString(toolEntry.getDescription()) + " [" + acceleratorText + "]");
        }
    }

    private static String getAcceleratorText(String parameterValue) {
        if (parameterValue == null || !PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        Command command = ((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand(COMMAND_ID);
        if (command == null) {
            return null;
        }
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, Map.of(PARAMETER_ID, parameterValue));
        if (parameterizedCommand == null) {
            return null;
        }
        Binding[] bindingArray = ((IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            if (parameterizedCommand.equals((Object)binding.getParameterizedCommand())) {
                return binding.getTriggerSequence().format();
            }
            ++n2;
        }
        return null;
    }
}

