/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.ConnectionRouterTypeCommand;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ConnectionRouterAction
extends Action
implements Disposable {
    public static String CONNECTION_ROUTER_BENDPONT = Messages.ConnectionRouterAction_0;
    public static String CONNECTION_ROUTER_MANHATTAN = Messages.ConnectionRouterAction_2;
    public static List<Integer> CONNECTION_ROUTER_TYPES = Arrays.asList(0, 2);
    private IWorkbenchPart part;
    private IDiagramModel diagramModel;
    private Adapter eAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Object feature = msg.getFeature();
            if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL__CONNECTION_ROUTER_TYPE) {
                ConnectionRouterAction.this.update();
            }
        }
    };

    public ConnectionRouterAction(IWorkbenchPart part) {
        super(null, 8);
        this.part = part;
        this.diagramModel = (IDiagramModel)part.getAdapter(IDiagramModel.class);
        this.diagramModel.eAdapters().add((Object)this.eAdapter);
        this.update();
    }

    public void run() {
        if (this.isChecked()) {
            CommandStack stack = (CommandStack)this.part.getAdapter(CommandStack.class);
            stack.execute((Command)new ConnectionRouterTypeCommand(this.diagramModel, this.getType()));
        }
    }

    protected void update() {
        int type = this.diagramModel.getConnectionRouterType();
        if (CONNECTION_ROUTER_TYPES.indexOf(type) == -1) {
            type = 0;
        }
        this.setChecked(type == this.getType());
    }

    protected abstract int getType();

    public void dispose() {
        this.diagramModel.eAdapters().remove((Object)this.eAdapter);
    }

    public static class BendPointConnectionRouterAction
    extends ConnectionRouterAction {
        public static String ID = "BendPointConnectionAction";

        public BendPointConnectionRouterAction(IWorkbenchPart part) {
            super(part);
            this.setId(ID);
            this.setText(CONNECTION_ROUTER_BENDPONT);
        }

        @Override
        public int getType() {
            return 0;
        }
    }

    public static class ManhattanConnectionRouterAction
    extends ConnectionRouterAction {
        public static String ID = "ManhattanConnectionAction";

        public ManhattanConnectionRouterAction(IWorkbenchPart part) {
            super(part);
            this.setId(ID);
            this.setText(CONNECTION_ROUTER_MANHATTAN);
        }

        @Override
        public int getType() {
            return 2;
        }
    }
}

