/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.CopySnapshot;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.actions.PasteAction;
import com.archimatetool.editor.ui.LocalClipboard;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends SelectionAction {
    protected PasteAction fPasteAction;

    public CopyAction(IWorkbenchPart part, PasteAction pasteAction) {
        super(part);
        this.fPasteAction = pasteAction;
    }

    protected void init() {
        this.setText(Messages.CopyAction_0);
        this.setId(ActionFactory.COPY.getId());
        this.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return false;
        }
        for (Object object : selected) {
            Object model;
            if (!(object instanceof EditPart) || (model = ((EditPart)object).getModel()) instanceof ILockable && ((ILockable)model).isLocked() || !(model instanceof IDiagramModelObject)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        ArrayList<IDiagramModelComponent> selected = new ArrayList<IDiagramModelComponent>();
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || (model = ((EditPart)object).getModel()) instanceof ILockable && ((ILockable)model).isLocked() || !(model instanceof IDiagramModelComponent)) continue;
            selected.add((IDiagramModelComponent)model);
        }
        CopySnapshot clipBoardCopy = new CopySnapshot(selected);
        LocalClipboard.getDefault().setContents(clipBoardCopy);
        this.fPasteAction.reset();
    }
}

