/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.SetConstraintObjectCommand;
import com.archimatetool.editor.diagram.editparts.AbstractConnectedEditPart;
import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbenchPart;

public class DefaultEditPartSizeAction
extends SelectionAction {
    public static final String ID = "com.archimatetool.action.defaultSize";
    public static final String TEXT = Messages.DefaultEditPartSizeAction_0;

    public DefaultEditPartSizeAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setToolTipText(Messages.DefaultEditPartSizeAction_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/default-size.png"));
    }

    public void run() {
        this.execute(this.createDefaultSizeCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return false;
        }
        return this.createDefaultSizeCommand(selected).canExecute();
    }

    private Command createDefaultSizeCommand(List<?> objects) {
        CompoundCommand command = new CompoundCommand();
        for (Object object : objects) {
            AbstractConnectedEditPart editPart;
            IDiagramModelObject model;
            if (!(object instanceof AbstractConnectedEditPart) || (model = (editPart = (AbstractConnectedEditPart)((Object)object)).getModel()) instanceof ILockable && ((ILockable)model).isLocked()) continue;
            AbstractDiagramModelObjectFigure figure = (AbstractDiagramModelObjectFigure)editPart.getFigure();
            IBounds bounds = model.getBounds().getCopy();
            if (model instanceof IIconic && ((IIconic)model).getImagePosition() == 9 && figure.hasIconImage() && (!(model instanceof IDiagramModelContainer) || ((IDiagramModelContainer)model).getChildren().isEmpty())) {
                Rectangle imageBounds = figure.getIconicDelegate().getImage().getBounds();
                bounds.setWidth(imageBounds.width);
                bounds.setHeight(imageBounds.height);
            } else {
                Dimension defaultSize = figure.getDefaultSize();
                bounds.setWidth(defaultSize.width);
                bounds.setHeight(defaultSize.height);
            }
            if (bounds.getWidth() == model.getBounds().getWidth() && bounds.getHeight() == model.getBounds().getHeight()) continue;
            SetConstraintObjectCommand cmd = new SetConstraintObjectCommand(model, bounds);
            command.add((Command)cmd);
        }
        return command.unwrap();
    }
}

