/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.model.commands.AddListMemberCommand;
import com.archimatetool.editor.model.commands.AlwaysExecutingChainedCompoundCommand;
import com.archimatetool.editor.model.commands.RemoveListMemberCommand;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteContainerAction
extends SelectionAction {
    public static final String ID = "com.archimatetool.editor.action.deleteContainer";
    public static final String TEXT = Messages.DeleteContainerAction_0;
    public static final String TOOLTIP_TEXT = Messages.DeleteContainerAction_1;

    public DeleteContainerAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setToolTipText(TOOLTIP_TEXT);
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    protected boolean calculateEnabled() {
        return !this.getObjectsToBeDeleted().isEmpty();
    }

    public void run() {
        AlwaysExecutingChainedCompoundCommand compoundCommand = new AlwaysExecutingChainedCompoundCommand(TEXT){

            public void execute() {
                for (IDiagramModelObject dmo : DeleteContainerAction.this.getObjectsToBeDeleted()) {
                    IDiagramModelContainer parent = (IDiagramModelContainer)dmo.eContainer();
                    EList children = ((IDiagramModelContainer)dmo).getChildren();
                    this.add(DiagramCommandFactory.createDeleteDiagramObjectCommand(dmo, false));
                    for (IDiagramModelObject child : new ArrayList(children)) {
                        this.add(new RemoveListMemberCommand<IDiagramModelObject>((List<IDiagramModelObject>)children, child));
                        this.add(new ChangePositionCommand(child, dmo.getBounds()));
                        this.add(new AddListMemberCommand<IDiagramModelObject>((List<IDiagramModelObject>)parent.getChildren(), child));
                    }
                }
            }
        };
        this.execute((Command)compoundCommand);
    }

    private List<IDiagramModelObject> getObjectsToBeDeleted() {
        ArrayList<IDiagramModelObject> list = new ArrayList<IDiagramModelObject>();
        for (Object object : this.getSelectedObjects()) {
            if (!this.isValidObject(object)) continue;
            list.add((IDiagramModelObject)((EditPart)object).getModel());
        }
        return list;
    }

    private boolean isValidObject(Object object) {
        IDiagramModelObject dmo;
        EditPart editPart;
        Object object2;
        if (object instanceof EditPart && (object2 = (editPart = (EditPart)object).getModel()) instanceof IDiagramModelObject && (dmo = (IDiagramModelObject)object2) instanceof IDiagramModelContainer) {
            ILockable lockable;
            IDiagramModelContainer container = (IDiagramModelContainer)dmo;
            if (!(!(dmo.eContainer() instanceof IDiagramModelContainer) || dmo instanceof ILockable && (lockable = (ILockable)dmo).isLocked() || container.getChildren().isEmpty())) {
                return true;
            }
        }
        return false;
    }

    private static class ChangePositionCommand
    extends Command {
        private IDiagramModelObject dmo;
        private IBounds oldBounds;
        private IBounds newBounds;

        public ChangePositionCommand(IDiagramModelObject dmo, IBounds parentBounds) {
            this.dmo = dmo;
            this.oldBounds = dmo.getBounds();
            this.newBounds = IArchimateFactory.eINSTANCE.createBounds(this.oldBounds.getX() + parentBounds.getX(), this.oldBounds.getY() + parentBounds.getY(), this.oldBounds.getWidth(), this.oldBounds.getHeight());
        }

        public void execute() {
            this.dmo.setBounds(this.newBounds);
        }

        public void undo() {
            this.dmo.setBounds(this.oldBounds);
        }

        public void dispose() {
            this.dmo = null;
            this.oldBounds = null;
            this.newBounds = null;
        }
    }
}

