/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.ui.ClipboardImageTransfer;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.model.IDiagramModel;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class ExportAsImageToClipboardAction
extends WorkbenchPartAction {
    public static final String ID = "com.archimatetool.editor.action.exportAsImageToClipboard";
    public static final String TEXT = Messages.ExportAsImageToClipboardAction_0;

    public ExportAsImageToClipboardAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
        this.setActionDefinitionId(this.getId());
    }

    public void run() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Image image = null;
                try {
                    try {
                        IDiagramModel diagramModel = (IDiagramModel)ExportAsImageToClipboardAction.this.getWorkbenchPart().getAdapter(IDiagramModel.class);
                        image = DiagramUtils.createImage(diagramModel, 1.0, 10);
                        ImageData imageData = image.getImageData(ImageFactory.getImageDeviceZoom());
                        ClipboardImageTransfer.copyImageDataToClipboard(imageData);
                    }
                    catch (Throwable ex) {
                        Logger.log(4, "Error exporting image", ex);
                        MessageDialog.openError((Shell)ExportAsImageToClipboardAction.this.getWorkbenchPart().getSite().getShell(), (String)Messages.ExportAsImageToClipboardAction_0, (String)(Messages.ExportAsImageToClipboardAction_3 + " " + (ex.getMessage() == null ? ex.toString() : ex.getMessage())));
                        if (image != null) {
                            image.dispose();
                        }
                    }
                }
                finally {
                    if (image != null) {
                        image.dispose();
                    }
                }
            }
        });
    }

    protected boolean calculateEnabled() {
        return true;
    }
}

