/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.actions.ArchiActionFactory;
import com.archimatetool.editor.diagram.FloatingPalette;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.PartListenerAdapter;
import com.archimatetool.editor.utils.PlatformUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public class FullScreenAction
extends WorkbenchPartAction {
    public static final String ID = "com.archimatetool.editor.action.fullScreen";
    public static final String TEXT = Messages.FullScreenAction_0;
    private GraphicalViewer fGraphicalViewer;
    private Shell fNewShell;
    private Composite fOldParent;
    private PaletteViewer fOldPaletteViewer;
    private FloatingPalette fFloatingPalette;
    private List<KeyBinding> keyBindings;
    private Listener keyListener = e -> {
        IAction action;
        Object o;
        if (e.keyCode == 27) {
            e.doit = false;
            this.close();
        }
        if ((o = this.getKeyActionOrCommandId(e)) instanceof IAction && (action = (IAction)o).isEnabled()) {
            action.run();
        } else if (o instanceof String) {
            String commandId = (String)o;
            ICommandService commandService = (ICommandService)this.getWorkbenchPart().getSite().getService(ICommandService.class);
            Command command = commandService.getCommand(commandId);
            if (command.isDefined() && command.isEnabled()) {
                try {
                    IHandlerService handlerService = (IHandlerService)this.getWorkbenchPart().getSite().getService(IHandlerService.class);
                    handlerService.executeCommand(commandId, null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    };
    private IMenuListener contextMenuListener = manager -> {
        manager.add((IContributionItem)new Separator());
        if (!this.fFloatingPalette.isOpen()) {
            manager.add((IAction)new Action(Messages.FullScreenAction_1){

                public void run() {
                    FullScreenAction.this.fFloatingPalette.open();
                }
            });
        }
        manager.add((IAction)new Action(Messages.FullScreenAction_2){

            public void run() {
                FullScreenAction.this.close();
            }

            public int getAccelerator() {
                return 27;
            }
        });
    };
    private IPartListener partListener = new PartListenerAdapter(){

        @Override
        public void partDeactivated(IWorkbenchPart part) {
            if (part == FullScreenAction.this.getWorkbenchPart()) {
                FullScreenAction.this.close();
            }
        }

        @Override
        public void partOpened(IWorkbenchPart part) {
            FullScreenAction.this.close();
        }
    };

    public FullScreenAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    public void run() {
        this.fGraphicalViewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        this.fOldParent = this.fGraphicalViewer.getControl().getParent();
        this.fOldPaletteViewer = this.fGraphicalViewer.getEditDomain().getPaletteViewer();
        this.addKeyBindings();
        this.fGraphicalViewer.getContextMenu().addMenuListener(this.contextMenuListener);
        this.fGraphicalViewer.getControl().addListener(1, this.keyListener);
        int style = PlatformUtils.isWindows() || PlatformUtils.isLinuxX11() ? 0 : 16;
        this.fNewShell = new Shell(Display.getCurrent(), style);
        this.fNewShell.setLocation(this.fOldParent.getShell().getLocation());
        this.fNewShell.setFullScreen(true);
        this.fNewShell.setMaximized(true);
        this.fNewShell.setText(Display.getAppName());
        this.fNewShell.setLayout((Layout)new FillLayout());
        this.fNewShell.setImage(IArchiImages.ImageFactory.getImage("img/app-128.png"));
        this.fNewShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FullScreenAction.this.close();
            }
        });
        this.fGraphicalViewer.getControl().setParent((Composite)this.fNewShell);
        this.fNewShell.layout();
        this.fNewShell.open();
        this.fFloatingPalette = new FloatingPalette((IDiagramModelEditor)((DefaultEditDomain)this.fGraphicalViewer.getEditDomain()).getEditorPart(), this.fNewShell);
        if (this.fFloatingPalette.getPaletteState().isOpen) {
            this.fFloatingPalette.open();
        }
        this.fOldParent.getShell().setEnabled(false);
        this.getWorkbenchPart().getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        this.fNewShell.setFocus();
    }

    private void close() {
        if (this.fGraphicalViewer == null) {
            return;
        }
        this.fFloatingPalette.close();
        this.fGraphicalViewer.getContextMenu().removeMenuListener(this.contextMenuListener);
        this.fGraphicalViewer.getControl().removeListener(1, this.keyListener);
        this.getWorkbenchPart().getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.fGraphicalViewer.getEditDomain().setPaletteViewer(this.fOldPaletteViewer);
        this.fGraphicalViewer.getControl().setParent(this.fOldParent);
        this.fOldParent.layout();
        this.fOldParent.getShell().setEnabled(true);
        this.getWorkbenchPart().getSite().getWorkbenchWindow().getShell().setFocus();
        this.dispose();
    }

    private void addKeyBindings() {
        this.keyBindings = new ArrayList<KeyBinding>();
        ActionRegistry registry = (ActionRegistry)this.getWorkbenchPart().getAdapter(ActionRegistry.class);
        IBindingService service = (IBindingService)this.getWorkbenchPart().getSite().getService(IBindingService.class);
        this.addActionKeyBinding(registry, service, ActionFactory.SELECT_ALL);
        this.addActionKeyBinding(registry, service, ActionFactory.UNDO);
        this.addActionKeyBinding(registry, service, ActionFactory.REDO);
        this.addActionKeyBinding(registry, service, ActionFactory.DELETE);
        this.addActionKeyBinding(registry, service, ActionFactory.CUT);
        this.addActionKeyBinding(registry, service, ActionFactory.COPY);
        this.addActionKeyBinding(registry, service, ActionFactory.PASTE);
        this.addActionKeyBinding(registry, service, ArchiActionFactory.PASTE_SPECIAL);
        this.addActionKeyBinding(registry, service, ActionFactory.RENAME);
        this.addActionKeyBinding(registry, service, "org.eclipse.gef.zoom_in", "org.eclipse.gef.zoom_in");
        this.addActionKeyBinding(registry, service, "org.eclipse.gef.zoom_out", "org.eclipse.gef.zoom_out");
        this.addActionKeyBinding(registry, service, "org.eclipse.gef.zoom_normal", "org.eclipse.gef.zoom_normal");
        this.addCommandKeyBinding(service, "org.eclipse.ui.file.save");
    }

    private void addCommandKeyBinding(IBindingService service, String commandId) {
        KeyStroke ks = this.getKeyStroke(service, commandId);
        if (ks != null) {
            this.keyBindings.add(new KeyBinding(ks.getModifierKeys(), Character.toLowerCase(ks.getNaturalKey()), commandId));
        }
    }

    private void addActionKeyBinding(ActionRegistry registry, IBindingService service, ActionFactory actionFactory) {
        this.addActionKeyBinding(registry, service, actionFactory.getId(), actionFactory.getCommandId());
    }

    private void addActionKeyBinding(ActionRegistry registry, IBindingService service, String actionId, String commandId) {
        KeyStroke ks = this.getKeyStroke(service, commandId);
        if (ks != null) {
            this.keyBindings.add(new KeyBinding(ks.getModifierKeys(), Character.toLowerCase(ks.getNaturalKey()), registry.getAction((Object)actionId)));
        }
    }

    private Object getKeyActionOrCommandId(Event e) {
        if (this.keyBindings == null) {
            return null;
        }
        int mod = e.stateMask;
        int key = Character.toLowerCase(e.keyCode);
        for (KeyBinding kb : this.keyBindings) {
            if (mod != kb.modKeys || key != kb.key) continue;
            return kb.actionOrCommandId;
        }
        return null;
    }

    private KeyStroke getKeyStroke(IBindingService service, String commandId) {
        KeySequence seq = (KeySequence)service.getBestActiveBindingFor(commandId);
        return seq != null && seq.getKeyStrokes().length > 0 ? seq.getKeyStrokes()[0] : null;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void dispose() {
        if (this.fNewShell != null) {
            this.fNewShell.dispose();
        }
        this.fGraphicalViewer = null;
        this.keyBindings = null;
        this.fNewShell = null;
        this.fOldParent = null;
        this.fFloatingPalette = null;
    }

    private static class KeyBinding {
        int modKeys;
        int key;
        Object actionOrCommandId;

        public KeyBinding(int modKeys, int key, Object actionOrCommandId) {
            this.modKeys = modKeys;
            this.key = key;
            this.actionOrCommandId = actionOrCommandId;
        }
    }
}

