/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.LineWidthCommand;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILineObject;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class LineWidthAction
extends SelectionAction {
    public static final String ID = "LineWidthAction";
    public static final String TEXT = Messages.LineWidthAction_0;

    public LineWidthAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return this.getFirstValidSelectedModelObject(this.getSelectedObjects()) != null;
    }

    private Object getFirstValidSelectedModelObject(List<?> selection) {
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel())) continue;
            return model;
        }
        return null;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        ILineObject model = (ILineObject)this.getFirstValidSelectedModelObject(selection);
        if (model == null) {
            return;
        }
        int lineWidth = model.getLineWidth();
        LineWidthDialog dialog = new LineWidthDialog(this.getWorkbenchPart().getSite().getShell(), lineWidth);
        if (dialog.open() == 0) {
            this.execute(this.createCommand(selection, dialog.getLineWidth()));
        }
    }

    private Command createCommand(List<?> selection, int newLineWidth) {
        CompoundCommand result = new CompoundCommand(Messages.LineWidthAction_1);
        for (Object object : selection) {
            LineWidthCommand cmd;
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel()) || !(cmd = new LineWidthCommand((ILineObject)model, newLineWidth)).canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private boolean shouldEnable(Object model) {
        if (model instanceof ILockable && ((ILockable)model).isLocked()) {
            return false;
        }
        if (model instanceof ILineObject) {
            ILineObject lo = (ILineObject)model;
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)lo);
            return provider != null && provider.shouldExposeFeature(IArchimatePackage.Literals.LINE_OBJECT__LINE_WIDTH.getName());
        }
        return false;
    }

    private static class LineWidthDialog
    extends Dialog {
        private Combo fCombo;
        private int fLineWidth;
        private static final String[] comboLineWidthItems = new String[]{Messages.LineWidthAction_2, Messages.LineWidthAction_3, Messages.LineWidthAction_4};

        protected LineWidthDialog(Shell parent, int lineWidth) {
            super(parent);
            this.fLineWidth = lineWidth;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.LineWidthAction_1);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.fCombo = new Combo(composite, 8);
            this.fCombo.setItems(comboLineWidthItems);
            this.fCombo.setLayoutData((Object)new GridData(768));
            this.fCombo.select(this.fLineWidth - 1);
            return composite;
        }

        protected int getLineWidth() {
            return this.fLineWidth;
        }

        protected void okPressed() {
            this.fLineWidth = this.fCombo.getSelectionIndex() + 1;
            super.okPressed();
        }
    }
}

