/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.LockObjectCommand;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;

public class LockObjectAction
extends SelectionAction {
    public static final String ID = "LockObjectAction";

    public LockObjectAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.LockObjectAction_0);
        this.setId(ID);
        this.setToolTipText(Messages.LockObjectAction_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/lockedstate.png"));
    }

    public void run() {
        this.execute(this.createLockCommand(this.getSelectedObjects()));
        this.updateText();
    }

    private boolean isToLock() {
        for (Object object : this.getSelectedObjects()) {
            EditPart part;
            if (!(object instanceof EditPart) || !((part = (EditPart)object).getModel() instanceof ILockable)) continue;
            ILockable model = (ILockable)part.getModel();
            return !model.isLocked();
        }
        return true;
    }

    private void updateText() {
        boolean lock = this.isToLock();
        this.setText(lock ? Messages.LockObjectAction_0 : Messages.LockObjectAction_2);
        this.setImageDescriptor(lock ? IArchiImages.ImageFactory.getImageDescriptor("img/lockedstate.png") : IArchiImages.ImageFactory.getImageDescriptor("img/unlockedstate.png"));
    }

    protected boolean calculateEnabled() {
        this.updateText();
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return false;
        }
        for (Object object : selected) {
            if (object instanceof EditPart) continue;
            return false;
        }
        Command command = this.createLockCommand(selected);
        if (command == null) {
            return false;
        }
        return command.canExecute();
    }

    private Command createLockCommand(List<?> objects) {
        CompoundCommand command = new CompoundCommand();
        boolean lock = this.isToLock();
        for (Object object : objects) {
            ILockable model;
            EditPart part;
            if (!(object instanceof EditPart) || !((part = (EditPart)object).getModel() instanceof ILockable) || (model = (ILockable)part.getModel()).isLocked() == lock) continue;
            LockObjectCommand cmd = new LockObjectCommand(model, lock);
            command.add((Command)cmd);
        }
        return command.unwrap();
    }
}

