/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.CopySnapshot;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.ui.ILocalClipboardListener;
import com.archimatetool.editor.ui.LocalClipboard;
import com.archimatetool.model.IDiagramModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends SelectionAction {
    private boolean fPasteSpecial = false;
    private GraphicalViewer fGraphicalViewer;
    private Point fMousePosition = null;
    private ILocalClipboardListener clipBoardListener = new ILocalClipboardListener(){

        @Override
        public void clipBoardChanged(Object clipboardContents) {
            PasteAction.this.refresh();
        }
    };
    private MouseListener mouseListener = new MouseListener(){

        public void mousePressed(MouseEvent me) {
            Point pt = new Point(me.x, me.y);
            ((IFigure)me.getSource()).translateFromParent((Translatable)pt);
            PasteAction.this.fMousePosition = pt;
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    };

    public PasteAction(IWorkbenchPart part, GraphicalViewer viewer) {
        super(part);
        this.fGraphicalViewer = viewer;
        this.setText(Messages.PasteAction_0);
        this.setId(ActionFactory.PASTE.getId());
        this.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setEnabled(false);
        LocalClipboard.getDefault().addListener(this.clipBoardListener);
        ((GraphicalEditPart)this.fGraphicalViewer.getRootEditPart()).getFigure().addMouseListener(this.mouseListener);
    }

    protected boolean calculateEnabled() {
        Object obj = LocalClipboard.getDefault().getContents();
        if (obj instanceof CopySnapshot) {
            CopySnapshot clipBoardCopy = (CopySnapshot)obj;
            return clipBoardCopy.canPasteToDiagram(this.getTargetDiagramModel());
        }
        return false;
    }

    public void run() {
        CopySnapshot clipBoardCopy;
        Object obj = LocalClipboard.getDefault().getContents();
        if (obj instanceof CopySnapshot && (clipBoardCopy = (CopySnapshot)obj).canPasteToDiagram(this.getTargetDiagramModel())) {
            this.execute(clipBoardCopy.getPasteCommand(this.getTargetDiagramModel(), this.fGraphicalViewer, this.fMousePosition, this.fPasteSpecial));
            this.fMousePosition = null;
        }
    }

    void reset() {
        this.update();
        this.fMousePosition = null;
    }

    private IDiagramModel getTargetDiagramModel() {
        IDiagramModel diagramModel = (IDiagramModel)this.getWorkbenchPart().getAdapter(IDiagramModel.class);
        if (diagramModel == null) {
            System.err.println("DiagramModel was null in " + String.valueOf(((Object)((Object)this)).getClass()));
        }
        return diagramModel;
    }

    public void dispose() {
        super.dispose();
        LocalClipboard.getDefault().removeListener(this.clipBoardListener);
        ((GraphicalEditPart)this.fGraphicalViewer.getRootEditPart()).getFigure().removeMouseListener(this.mouseListener);
        this.fGraphicalViewer = null;
    }

    public void setPasteSpecial(boolean pasteSpecial) {
        this.fPasteSpecial = pasteSpecial;
    }
}

