/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.SetConstraintObjectCommand;
import com.archimatetool.editor.diagram.editparts.AbstractConnectedEditPart;
import com.archimatetool.editor.diagram.figures.AbstractDiagramModelObjectFigure;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModelImage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IIconic;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IWorkbenchPart;

public class ResetAspectRatioAction
extends SelectionAction {
    public static final String ID = "ResetAspectRatioAction";
    public static final String TEXT = Messages.ResetAspectRatioAction_0;

    public ResetAspectRatioAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
        this.setToolTipText(Messages.ResetAspectRatioAction_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/aspect-ratio.png"));
    }

    public void run() {
        this.execute(this.createCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return false;
        }
        return this.createCommand(selected).canExecute();
    }

    private Command createCommand(List<?> objects) {
        CompoundCommand result = new CompoundCommand();
        for (Object object : objects) {
            if (!(object instanceof AbstractConnectedEditPart)) continue;
            AbstractConnectedEditPart editPart = (AbstractConnectedEditPart)((Object)object);
            AbstractDiagramModelObjectFigure figure = (AbstractDiagramModelObjectFigure)editPart.getFigure();
            IDiagramModelObject dmo = editPart.getModel();
            if (!this.isDiagramObjectWithImage(dmo) && !this.isIconicWithImageFill(dmo, figure) || dmo instanceof ILockable && ((ILockable)dmo).isLocked()) continue;
            IBounds modelBounds = dmo.getBounds().getCopy();
            int currentHeight = modelBounds.getHeight();
            int currentWidth = modelBounds.getWidth();
            if (currentHeight < 1 || currentWidth < 1) continue;
            float currentRatio = (float)currentHeight / (float)currentWidth;
            float otherRatio = 0.0f;
            if (dmo instanceof IDiagramModelImage) {
                Dimension size = figure.getDefaultSize();
                if (size.height == 0 || size.width == 0) continue;
                otherRatio = (float)size.height / (float)size.width;
            } else {
                Rectangle imageBounds = figure.getIconicDelegate().getImage().getBounds();
                otherRatio = (float)imageBounds.height / (float)imageBounds.width;
            }
            if (otherRatio == 0.0f || !((double)Math.abs(otherRatio - currentRatio) > 0.01)) continue;
            if (currentWidth < currentHeight) {
                currentWidth = (int)((float)currentHeight / otherRatio);
            } else {
                currentHeight = (int)((float)currentWidth * otherRatio);
            }
            modelBounds.setWidth(currentWidth);
            modelBounds.setHeight(currentHeight);
            SetConstraintObjectCommand cmd = new SetConstraintObjectCommand(dmo, modelBounds);
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private boolean isIconicWithImageFill(IDiagramModelObject dmo, AbstractDiagramModelObjectFigure figure) {
        return dmo instanceof IIconic && ((IIconic)dmo).getImagePosition() == 9 && figure.hasIconImage();
    }

    private boolean isDiagramObjectWithImage(IDiagramModelObject dmo) {
        return dmo instanceof IDiagramModelImage && ((IDiagramModelImage)dmo).getImagePath() != null;
    }
}

