/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class SelectAllAction
extends Action {
    private IWorkbenchPart part;

    public SelectAllAction(IWorkbenchPart part) {
        this.part = part;
        this.setText(Messages.SelectAllAction_0);
        this.setToolTipText(Messages.SelectAllAction_1);
        this.setId(ActionFactory.SELECT_ALL.getId());
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.part.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.setSelection((ISelection)new StructuredSelection(this.getSelectableEditParts(viewer.getContents()).toArray()));
        }
    }

    Set<GraphicalEditPart> getSelectableEditParts(EditPart editpart) {
        HashSet<GraphicalEditPart> selected = new HashSet<GraphicalEditPart>();
        for (Object child : editpart.getChildren()) {
            GraphicalEditPart connectionEditPart;
            GraphicalEditPart childPart;
            if (!(child instanceof GraphicalEditPart) || !(childPart = (GraphicalEditPart)child).isSelectable()) continue;
            selected.add(childPart);
            for (Object o : childPart.getSourceConnections()) {
                connectionEditPart = (GraphicalEditPart)o;
                if (!connectionEditPart.isSelectable()) continue;
                selected.add(connectionEditPart);
            }
            for (Object o : childPart.getTargetConnections()) {
                connectionEditPart = (GraphicalEditPart)o;
                if (!connectionEditPart.isSelectable()) continue;
                selected.add(connectionEditPart);
            }
            selected.addAll(this.getSelectableEditParts((EditPart)childPart));
        }
        return selected;
    }
}

