/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectSameObjectTypeAction
extends SelectionAction {
    public static final String ID = "com.archimatetool.editor.selectSameObjectType";

    public SelectSameObjectTypeAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.SelectSameObjectTypeAction_0);
        this.setId(ID);
        this.setActionDefinitionId(ID);
        IHandlerService service = (IHandlerService)part.getSite().getService(IHandlerService.class);
        service.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    protected boolean calculateEnabled() {
        for (Object object : this.getSelectedObjects()) {
            EditPart editPart;
            if (!(object instanceof EditPart) || this.getObjectClass((editPart = (EditPart)object).getModel()) == null) continue;
            return true;
        }
        return false;
    }

    public void run() {
        IDiagramModelEditor editor = (IDiagramModelEditor)this.getWorkbenchPart();
        ArrayList<EObject> sameObjects = new ArrayList<EObject>();
        Set<EClass> selectedTypes = this.getSelectedTypes();
        TreeIterator iter = editor.getModel().eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!selectedTypes.contains(this.getObjectClass(eObject))) continue;
            sameObjects.add(eObject);
        }
        if (sameObjects.size() > 1) {
            editor.selectObjects(sameObjects.toArray());
        }
    }

    private Set<EClass> getSelectedTypes() {
        HashSet<EClass> selected = new HashSet<EClass>();
        for (Object object : this.getSelectedObjects()) {
            EditPart editPart;
            EClass eClass;
            if (!(object instanceof EditPart) || (eClass = this.getObjectClass((editPart = (EditPart)object).getModel())) == null) continue;
            selected.add(eClass);
        }
        return selected;
    }

    private EClass getObjectClass(Object object) {
        if (object instanceof IDiagramModelArchimateComponent) {
            IDiagramModelArchimateComponent dmac = (IDiagramModelArchimateComponent)object;
            return dmac.getArchimateConcept().eClass();
        }
        if (object instanceof IDiagramModelComponent) {
            IDiagramModelComponent dmc = (IDiagramModelComponent)object;
            if (!(object instanceof IDiagramModel)) {
                return dmc.eClass();
            }
        }
        return null;
    }
}

