/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.TextAlignmentCommand;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILockable;
import com.archimatetool.model.ITextAlignment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;

public class TextAlignmentAction
extends SelectionAction {
    public static final String ACTION_LEFT_ID = "com.archimatetool.editor.textAlignmentLeft";
    public static final String ACTION_CENTRE_ID = "com.archimatetool.editor.textAlignmentCentre";
    public static final String ACTION_RIGHT_ID = "com.archimatetool.editor.textAlignmentRight";
    private int fAlignment;

    public static final TextAlignmentActionDefinition[] getActionDefinitions() {
        return new TextAlignmentActionDefinition[]{new TextAlignmentActionDefinition(ACTION_LEFT_ID, 1, Messages.TextAlignmentAction_0), new TextAlignmentActionDefinition(ACTION_CENTRE_ID, 2, Messages.TextAlignmentAction_1), new TextAlignmentActionDefinition(ACTION_RIGHT_ID, 4, Messages.TextAlignmentAction_2)};
    }

    public static List<RetargetAction> createRetargetActions() {
        ArrayList<RetargetAction> list = new ArrayList<RetargetAction>();
        TextAlignmentActionDefinition[] textAlignmentActionDefinitionArray = TextAlignmentAction.getActionDefinitions();
        int n = textAlignmentActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextAlignmentActionDefinition a = textAlignmentActionDefinitionArray[n2];
            RetargetAction action = new RetargetAction(a.id(), a.label(), 8);
            action.setActionDefinitionId(a.id());
            list.add(action);
            ++n2;
        }
        return list;
    }

    public static List<TextAlignmentAction> createActions(IWorkbenchPart part) {
        ArrayList<TextAlignmentAction> list = new ArrayList<TextAlignmentAction>();
        TextAlignmentActionDefinition[] textAlignmentActionDefinitionArray = TextAlignmentAction.getActionDefinitions();
        int n = textAlignmentActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextAlignmentActionDefinition a = textAlignmentActionDefinitionArray[n2];
            list.add(new TextAlignmentAction(part, a.alignment(), a.id(), a.label()));
            ++n2;
        }
        return list;
    }

    public TextAlignmentAction(IWorkbenchPart part, int alignment, String id, String text) {
        super(part, 8);
        this.fAlignment = alignment;
        this.setId(id);
        this.setActionDefinitionId(id);
        this.setText(text);
    }

    public void run() {
        this.execute(this.createCommand());
    }

    protected boolean calculateEnabled() {
        List<ITextAlignment> selected = this.getValidSelectedObjects();
        boolean checked = !selected.isEmpty();
        for (ITextAlignment ta : selected) {
            if (ta.getTextAlignment() == this.fAlignment) continue;
            checked = false;
        }
        this.setChecked(checked);
        return !selected.isEmpty();
    }

    private Command createCommand() {
        CompoundCommand result = new CompoundCommand(Messages.TextAlignmentAction_3);
        for (ITextAlignment object : this.getValidSelectedObjects()) {
            TextAlignmentCommand cmd = new TextAlignmentCommand(object, this.fAlignment);
            if (!cmd.canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private List<ITextAlignment> getValidSelectedObjects() {
        ArrayList<ITextAlignment> list = new ArrayList<ITextAlignment>();
        for (Object object : this.getSelectedObjects()) {
            IGraphicalObjectUIProvider provider;
            IObjectUIProvider iObjectUIProvider;
            ILockable lockable;
            ITextAlignment textAlignmentObject;
            EditPart editPart;
            Object object2;
            if (!(object instanceof EditPart) || !((object2 = (editPart = (EditPart)object).getModel()) instanceof ITextAlignment) || (textAlignmentObject = (ITextAlignment)object2) instanceof ILockable && (lockable = (ILockable)textAlignmentObject).isLocked() || !((iObjectUIProvider = ObjectUIFactory.INSTANCE.getProvider((EObject)textAlignmentObject)) instanceof IGraphicalObjectUIProvider) || !(provider = (IGraphicalObjectUIProvider)iObjectUIProvider).shouldExposeFeature(IArchimatePackage.Literals.TEXT_ALIGNMENT__TEXT_ALIGNMENT.getName())) continue;
            list.add(textAlignmentObject);
        }
        return list;
    }

    public record TextAlignmentActionDefinition(String id, int alignment, String label) {
    }
}

