/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.TextPositionCommand;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.ILockable;
import com.archimatetool.model.ITextPosition;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;

public class TextPositionAction
extends SelectionAction {
    public static final String ACTION_TOP_ID = "com.archimatetool.editor.textPositionTop";
    public static final String ACTION_CENTRE_ID = "com.archimatetool.editor.textPositionCentre";
    public static final String ACTION_BOTTOM_ID = "com.archimatetool.editor.textPositionBottom";
    private int fPosition;

    public static final TextPositionActionDefinition[] getActionDefinitions() {
        return new TextPositionActionDefinition[]{new TextPositionActionDefinition(ACTION_TOP_ID, 0, Messages.TextPositionAction_0), new TextPositionActionDefinition(ACTION_CENTRE_ID, 1, Messages.TextPositionAction_1), new TextPositionActionDefinition(ACTION_BOTTOM_ID, 2, Messages.TextPositionAction_2)};
    }

    public static List<RetargetAction> createRetargetActions() {
        ArrayList<RetargetAction> list = new ArrayList<RetargetAction>();
        TextPositionActionDefinition[] textPositionActionDefinitionArray = TextPositionAction.getActionDefinitions();
        int n = textPositionActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextPositionActionDefinition a = textPositionActionDefinitionArray[n2];
            RetargetAction action = new RetargetAction(a.id(), a.label(), 8);
            action.setActionDefinitionId(a.id());
            list.add(action);
            ++n2;
        }
        return list;
    }

    public static List<TextPositionAction> createActions(IWorkbenchPart part) {
        ArrayList<TextPositionAction> list = new ArrayList<TextPositionAction>();
        TextPositionActionDefinition[] textPositionActionDefinitionArray = TextPositionAction.getActionDefinitions();
        int n = textPositionActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextPositionActionDefinition a = textPositionActionDefinitionArray[n2];
            list.add(new TextPositionAction(part, a.position(), a.id(), a.label()));
            ++n2;
        }
        return list;
    }

    public TextPositionAction(IWorkbenchPart part, int position, String id, String text) {
        super(part, 8);
        this.fPosition = position;
        this.setId(id);
        this.setActionDefinitionId(id);
        this.setText(text);
    }

    public void run() {
        this.execute(this.createCommand());
    }

    protected boolean calculateEnabled() {
        List<ITextPosition> selected = this.getValidSelectedObjects();
        boolean checked = !selected.isEmpty();
        for (ITextPosition tp : selected) {
            if (tp.getTextPosition() == this.fPosition) continue;
            checked = false;
        }
        this.setChecked(checked);
        return !selected.isEmpty();
    }

    private Command createCommand() {
        CompoundCommand result = new CompoundCommand(Messages.TextPositionAction_9);
        for (ITextPosition object : this.getValidSelectedObjects()) {
            TextPositionCommand cmd = new TextPositionCommand(object, this.fPosition);
            if (!cmd.canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private List<ITextPosition> getValidSelectedObjects() {
        ArrayList<ITextPosition> list = new ArrayList<ITextPosition>();
        for (Object object : this.getSelectedObjects()) {
            IGraphicalObjectUIProvider provider;
            IObjectUIProvider iObjectUIProvider;
            ILockable lockable;
            ITextPosition textPositionObject;
            EditPart editPart;
            Object object2;
            if (!(object instanceof EditPart) || !((object2 = (editPart = (EditPart)object).getModel()) instanceof ITextPosition) || (textPositionObject = (ITextPosition)object2) instanceof ILockable && (lockable = (ILockable)textPositionObject).isLocked() || !((iObjectUIProvider = ObjectUIFactory.INSTANCE.getProvider((EObject)textPositionObject)) instanceof IGraphicalObjectUIProvider) || !(provider = (IGraphicalObjectUIProvider)iObjectUIProvider).shouldExposeFeature(IArchimatePackage.Literals.TEXT_POSITION__TEXT_POSITION.getName())) continue;
            list.add(textPositionObject);
        }
        return list;
    }

    public record TextPositionActionDefinition(String id, int position, String label) {
    }
}

