/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.diagram.commands.CreateDiagramConnectionCommand;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class CreateDiagramArchimateConnectionWithDialogCommand
extends CreateDiagramConnectionCommand {
    private boolean fUseExistingRelation;

    public CreateDiagramArchimateConnectionWithDialogCommand(CreateConnectionRequest request) {
        super(request);
    }

    @Override
    public void execute() {
        this.fUseExistingRelation = this.checkToReuseExistingRelationship();
        super.execute();
        if (!this.fUseExistingRelation) {
            ((IDiagramModelArchimateConnection)this.fConnection).addArchimateConceptToModel(null);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (!this.fUseExistingRelation) {
            ((IDiagramModelArchimateConnection)this.fConnection).addArchimateConceptToModel(null);
        }
    }

    @Override
    public void undo() {
        super.undo();
        if (!this.fUseExistingRelation) {
            ((IDiagramModelArchimateConnection)this.fConnection).removeArchimateConceptFromModel();
        }
    }

    private boolean checkToReuseExistingRelationship() {
        if (this.fSource instanceof IDiagramModelArchimateComponent && this.fTarget instanceof IDiagramModelArchimateComponent) {
            ChooseRelationDialog dialog;
            IDiagramModelArchimateComponent source = (IDiagramModelArchimateComponent)this.fSource;
            IDiagramModelArchimateComponent target = (IDiagramModelArchimateComponent)this.fTarget;
            EClass classType = (EClass)this.fRequest.getNewObjectType();
            List<IArchimateRelationship> relations = this.getExistingRelationshipsOfType(classType, source.getArchimateConcept(), target.getArchimateConcept());
            if (!relations.isEmpty() && (dialog = new ChooseRelationDialog(ArchiLabelProvider.INSTANCE.getDefaultName(classType), NLS.bind((String)Messages.CreateArchimateConnectionWithDialogCommand_1, (Object)ArchiLabelProvider.INSTANCE.getLabel(source), (Object)ArchiLabelProvider.INSTANCE.getLabel(target)), relations)).open() == 0) {
                this.fConnection = this.createNewConnection();
                ((IDiagramModelArchimateConnection)this.fConnection).setArchimateRelationship(dialog.getSelected());
                return true;
            }
        }
        return false;
    }

    public void swapSourceAndTargetConcepts() {
        IConnectable tmp = this.fSource;
        this.fSource = this.fTarget;
        this.fTarget = tmp;
    }

    List<IArchimateRelationship> getExistingRelationshipsOfType(EClass classType, IArchimateConcept source, IArchimateConcept target) {
        ArrayList<IArchimateRelationship> relations = new ArrayList<IArchimateRelationship>();
        for (IArchimateRelationship relation : source.getSourceRelationships()) {
            if (!relation.eClass().equals(classType) || relation.getTarget() != target) continue;
            relations.add(relation);
        }
        return relations;
    }

    private static class ChooseRelationDialog
    extends ExtendedTitleAreaDialog {
        private String title;
        private String message;
        private List<IArchimateRelationship> relations;
        private RelationsTableViewer tableViewer;
        private IArchimateRelationship selected;

        private ChooseRelationDialog(String title, String message, List<IArchimateRelationship> relations) {
            super(Display.getCurrent().getActiveShell(), "ChooseExistingRelationDialog");
            this.setTitleImage(IArchiImages.ImageFactory.getImage("img/new_wiz.png"));
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setHelpAvailable(false);
            this.title = title;
            this.message = message;
            this.relations = relations;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.CreateArchimateConnectionWithDialogCommand_0);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(this.title);
            this.setMessage(this.message);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite client = new Composite(composite, 0);
            GridLayout layout = new GridLayout(1, false);
            client.setLayout((Layout)layout);
            client.setLayoutData((Object)new GridData(1808));
            Label label = new Label(client, 0);
            label.setText(Messages.CreateDiagramArchimateConnectionWithDialogCommand_1);
            Composite tableComp = new Composite(client, 2048);
            tableComp.setLayout((Layout)new TableColumnLayout());
            tableComp.setLayoutData((Object)new GridData(1808));
            this.tableViewer = new RelationsTableViewer(tableComp, 0);
            this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
            this.tableViewer.setInput(this.relations);
            this.tableViewer.addSelectionChangedListener(e -> {
                IArchimateRelationship iArchimateRelationship = this.selected = (IArchimateRelationship)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            });
            this.tableViewer.addDoubleClickListener(e -> this.okPressed());
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.relations.get(0)));
            return composite;
        }

        IArchimateRelationship getSelected() {
            return this.selected;
        }

        @Override
        protected Point getDefaultDialogSize() {
            return new Point(500, 350);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.CreateDiagramArchimateConnectionWithDialogCommand_2, true);
            this.createButton(parent, 1, Messages.CreateDiagramArchimateConnectionWithDialogCommand_0, false);
        }

        private class RelationsTableViewer
        extends TableViewer {
            RelationsTableViewer(Composite parent, int style) {
                super(parent, 0x10000 | style);
                this.setColumns();
                this.setContentProvider((IContentProvider)new RelationsTableViewerContentProvider());
                this.setLabelProvider((IBaseLabelProvider)new RelationsTableViewerLabelCellProvider());
            }

            private void setColumns() {
                Table table = this.getTable();
                table.setHeaderVisible(false);
                TableColumnLayout layout = (TableColumnLayout)this.getControl().getParent().getLayout();
                TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0);
                layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, false));
            }
        }

        private class RelationsTableViewerContentProvider
        implements IStructuredContentProvider {
            private RelationsTableViewerContentProvider() {
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return ChooseRelationDialog.this.relations.toArray();
            }
        }

        private class RelationsTableViewerLabelCellProvider
        extends LabelProvider {
            private RelationsTableViewerLabelCellProvider() {
            }

            public String getText(Object element) {
                return ArchiLabelProvider.INSTANCE.getLabel(element);
            }

            public Image getImage(Object element) {
                return ArchiLabelProvider.INSTANCE.getImage(element);
            }
        }
    }
}

