/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.diagram.dialog.NestedConnectionInfo;
import com.archimatetool.editor.diagram.dialog.NewNestedRelationDialog;
import com.archimatetool.editor.diagram.dialog.NewNestedRelationsDialog;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.preferences.ConnectionPreferences;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.ISpecializationRelationship;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class CreateNestedArchimateConnectionsWithDialogCommand
extends CompoundCommand {
    IDiagramModelArchimateObject fParentObject;
    List<IDiagramModelArchimateObject> fChildObjects;

    public CreateNestedArchimateConnectionsWithDialogCommand(IDiagramModelArchimateObject parentObject, IDiagramModelArchimateObject childObject) {
        this.fParentObject = parentObject;
        this.fChildObjects = new ArrayList<IDiagramModelArchimateObject>();
        this.fChildObjects.add(childObject);
    }

    public CreateNestedArchimateConnectionsWithDialogCommand(IDiagramModelArchimateObject parentObject, List<IDiagramModelArchimateObject> childObjects) {
        this.fParentObject = parentObject;
        this.fChildObjects = childObjects;
    }

    public void execute() {
        this.createConnectionDialogCommands();
        this.createNewConnectionCommands();
        super.execute();
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    private void createConnectionDialogCommands() {
        ExtendedTitleAreaDialog dialog;
        ArrayList<IDiagramModelArchimateObject> childObjectsForDialog = new ArrayList<IDiagramModelArchimateObject>();
        for (IDiagramModelArchimateObject childObject : this.fChildObjects) {
            if (childObject.getArchimateConcept() instanceof IJunction || !this.canAddNewRelationship(this.fParentObject, childObject)) continue;
            childObjectsForDialog.add(childObject);
        }
        if (childObjectsForDialog.size() == 1) {
            dialog = new NewNestedRelationDialog(this.fParentObject, (IDiagramModelArchimateObject)childObjectsForDialog.get(0));
            if (dialog.open() == 0 && (selected = ((NewNestedRelationDialog)dialog).getSelected()) != null) {
                CreateRelationshipAndDiagramArchimateConnectionCommand cmd = new CreateRelationshipAndDiagramArchimateConnectionCommand(((NestedConnectionInfo)selected).getSourceObject(), ((NestedConnectionInfo)selected).getTargetObject(), ((NestedConnectionInfo)selected).getRelationshipType());
                this.add((Command)cmd);
            }
        } else if (childObjectsForDialog.size() > 1 && (dialog = new NewNestedRelationsDialog(this.fParentObject, childObjectsForDialog)).open() == 0) {
            selected = ((NewNestedRelationsDialog)dialog).getSelected();
            Iterator iterator = selected.iterator();
            while (iterator.hasNext()) {
                NestedConnectionInfo sel = (NestedConnectionInfo)iterator.next();
                CreateRelationshipAndDiagramArchimateConnectionCommand cmd = new CreateRelationshipAndDiagramArchimateConnectionCommand(sel.getSourceObject(), sel.getTargetObject(), sel.getRelationshipType());
                this.add((Command)cmd);
            }
        }
    }

    private boolean canAddNewRelationship(IDiagramModelArchimateObject parentObject, IDiagramModelArchimateObject childObject) {
        IArchimateElement parentElement = parentObject.getArchimateElement();
        IArchimateElement childElement = childObject.getArchimateElement();
        Set<EClass> relationsClassesForNewRelations = ConnectionPreferences.getRelationsClassesForNewRelations();
        Set<EClass> relationsClassesForNewReverseRelations = ConnectionPreferences.getRelationsClassesForNewReverseRelations();
        for (IArchimateRelationship relation : parentElement.getSourceRelationships()) {
            if (relation.getTarget() != childElement || !relationsClassesForNewRelations.contains(relation.eClass())) continue;
            return false;
        }
        for (IArchimateRelationship relation : parentElement.getTargetRelationships()) {
            if (relation.getSource() != childElement) continue;
            if (relation instanceof ISpecializationRelationship && relationsClassesForNewRelations.contains(relation.eClass())) {
                return false;
            }
            if (!relationsClassesForNewReverseRelations.contains(relation.eClass())) continue;
            return false;
        }
        for (EClass eClass : relationsClassesForNewRelations) {
            if (!ArchimateModelUtils.isValidRelationship((IArchimateConcept)parentElement, (IArchimateConcept)childElement, (EClass)eClass)) continue;
            return true;
        }
        for (EClass eClass : relationsClassesForNewReverseRelations) {
            if (!ArchimateModelUtils.isValidRelationship((IArchimateConcept)childElement, (IArchimateConcept)parentElement, (EClass)eClass)) continue;
            return true;
        }
        return false;
    }

    private void createNewConnectionCommands() {
        IDiagramModelArchimateConnection dmc;
        IArchimateElement parentElement = this.fParentObject.getArchimateElement();
        for (IDiagramModelArchimateObject childObject : this.fChildObjects) {
            IArchimateElement childElement = childObject.getArchimateElement();
            boolean aConnectionExists = false;
            for (IArchimateRelationship relation : parentElement.getSourceRelationships()) {
                if (relation.getTarget() != childElement || !DiagramModelUtils.isNestedConnectionTypeRelationship(relation) || !DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)this.fParentObject, (IConnectable)childObject, relation)) continue;
                aConnectionExists = true;
                break;
            }
            if (!aConnectionExists) {
                for (IArchimateRelationship relation : parentElement.getSourceRelationships()) {
                    if (relation.getTarget() != childElement || !DiagramModelUtils.isNestedConnectionTypeRelationship(relation)) continue;
                    this.add(new CreateDiagramArchimateConnectionCommand((IDiagramModelArchimateComponent)this.fParentObject, (IDiagramModelArchimateComponent)childObject, relation));
                }
            }
            aConnectionExists = false;
            for (IArchimateRelationship relation : parentElement.getTargetRelationships()) {
                if (relation.getSource() != childElement || !DiagramModelUtils.isNestedConnectionTypeRelationship(relation) || !DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)childObject, (IConnectable)this.fParentObject, relation)) continue;
                aConnectionExists = true;
                break;
            }
            if (aConnectionExists) continue;
            for (IArchimateRelationship relation : parentElement.getTargetRelationships()) {
                if (relation.getSource() != childElement || !DiagramModelUtils.isNestedConnectionTypeRelationship(relation)) continue;
                this.add(new CreateDiagramArchimateConnectionCommand((IDiagramModelArchimateComponent)childObject, (IDiagramModelArchimateComponent)this.fParentObject, relation));
            }
        }
        for (IArchimateRelationship relation : parentElement.getSourceRelationships()) {
            if (!(relation.getTarget() instanceof IArchimateRelationship) || (dmc = this.findConnection((IArchimateRelationship)relation.getTarget())) == null || DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)this.fParentObject, (IConnectable)dmc, relation)) continue;
            this.add(new CreateDiagramArchimateConnectionCommand((IDiagramModelArchimateComponent)this.fParentObject, (IDiagramModelArchimateComponent)dmc, relation));
        }
        for (IArchimateRelationship relation : parentElement.getTargetRelationships()) {
            if (!(relation.getSource() instanceof IArchimateRelationship) || (dmc = this.findConnection((IArchimateRelationship)relation.getSource())) == null || DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)this.fParentObject, (IConnectable)dmc, relation)) continue;
            this.add(new CreateDiagramArchimateConnectionCommand((IDiagramModelArchimateComponent)this.fParentObject, (IDiagramModelArchimateComponent)dmc, relation));
        }
    }

    private IDiagramModelArchimateConnection findConnection(IArchimateRelationship relation) {
        for (IDiagramModelObject dmo : this.fParentObject.getChildren()) {
            for (IDiagramModelConnection dmc : dmo.getSourceConnections()) {
                if (!(dmc instanceof IDiagramModelArchimateConnection) || ((IDiagramModelArchimateConnection)dmc).getArchimateRelationship() != relation) continue;
                return (IDiagramModelArchimateConnection)dmc;
            }
            for (IDiagramModelConnection dmc : dmo.getTargetConnections()) {
                if (!(dmc instanceof IDiagramModelArchimateConnection) || ((IDiagramModelArchimateConnection)dmc).getArchimateRelationship() != relation) continue;
                return (IDiagramModelArchimateConnection)dmc;
            }
        }
        return null;
    }

    private static class AddRelationshipCommand
    extends Command {
        private IArchimateElement source;
        private IArchimateElement target;
        private IArchimateRelationship relationship;
        private IFolder folder;

        public AddRelationshipCommand(IArchimateElement source, IArchimateElement target, IArchimateRelationship relationship) {
            this.source = source;
            this.target = target;
            this.relationship = relationship;
        }

        public void execute() {
            this.relationship.connect((IArchimateConcept)this.source, (IArchimateConcept)this.target);
            this.folder = this.target.getArchimateModel().getDefaultFolderForObject((EObject)this.relationship);
            this.folder.getElements().add((Object)this.relationship);
        }

        public void undo() {
            this.folder.getElements().remove((Object)this.relationship);
            this.relationship.disconnect();
        }

        public void redo() {
            this.folder.getElements().add((Object)this.relationship);
            this.relationship.reconnect();
        }

        public void dispose() {
            this.source = null;
            this.target = null;
            this.folder = null;
            this.relationship = null;
        }
    }

    private static class CreateDiagramArchimateConnectionCommand
    extends Command {
        IDiagramModelArchimateConnection connection;
        IDiagramModelArchimateComponent source;
        IDiagramModelArchimateComponent target;
        IArchimateRelationship relationship;

        CreateDiagramArchimateConnectionCommand(IDiagramModelArchimateComponent source, IDiagramModelArchimateComponent target, IArchimateRelationship relationship) {
            this.source = source;
            this.target = target;
            this.relationship = relationship;
        }

        public void execute() {
            this.connection = IArchimateFactory.eINSTANCE.createDiagramModelArchimateConnection();
            this.connection.setArchimateRelationship(this.relationship);
            this.connection.connect((IConnectable)this.source, (IConnectable)this.target);
        }

        public void redo() {
            this.connection.reconnect();
        }

        public void undo() {
            this.connection.disconnect();
        }

        public void dispose() {
            this.connection = null;
            this.source = null;
            this.target = null;
            this.relationship = null;
        }
    }

    private static class CreateRelationshipAndDiagramArchimateConnectionCommand
    extends CompoundCommand {
        CreateRelationshipAndDiagramArchimateConnectionCommand(IDiagramModelArchimateObject sourceObject, IDiagramModelArchimateObject targetObject, EClass relationshipType) {
            IArchimateRelationship relationship = (IArchimateRelationship)IArchimateFactory.eINSTANCE.create(relationshipType);
            Command cmd = new AddRelationshipCommand(sourceObject.getArchimateElement(), targetObject.getArchimateElement(), relationship);
            this.add(cmd);
            cmd = new CreateDiagramArchimateConnectionCommand((IDiagramModelArchimateComponent)sourceObject, (IDiagramModelArchimateComponent)targetObject, relationship);
            this.add(cmd);
        }
    }
}

