/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.IAnimatableCommand;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SetConstraintObjectCommand
extends CompoundCommand
implements IAnimatableCommand {
    private IDiagramModelObject fObject;
    private IBounds fNewPos;
    private IBounds fOldPos;
    private ChangeBoundsRequest fRequest;

    public SetConstraintObjectCommand(IDiagramModelObject object, IBounds bounds) {
        this.fObject = object;
        this.fOldPos = object.getBounds();
        this.fNewPos = bounds;
        this.setLabel(Messages.SetConstraintObjectCommand_0);
    }

    public SetConstraintObjectCommand(ChangeBoundsRequest request, IDiagramModelObject object, Rectangle bounds) {
        this(object, IArchimateFactory.eINSTANCE.createBounds(bounds.x, bounds.y, bounds.width, bounds.height));
        this.fRequest = request;
    }

    public boolean canExecute() {
        if (this.fObject.eContainer() instanceof IDiagramModelContainer && !(this.fObject.eContainer() instanceof IDiagramModel)) {
            if (this.fNewPos.getX() < 0) {
                return false;
            }
            if (this.fNewPos.getY() < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean canRedo() {
        return this.canExecute();
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.fObject.setBounds(this.fNewPos);
        this.createChildConstraintCommands();
        super.execute();
    }

    public void undo() {
        super.undo();
        this.fObject.setBounds(this.fOldPos);
    }

    public void redo() {
        this.fObject.setBounds(this.fNewPos);
        super.execute();
    }

    protected void createChildConstraintCommands() {
        int n;
        IBounds newbounds;
        int n2;
        if (ArchiPlugin.getInstance().getPreferenceStore().getInt("resizeBehaviour") != 0 || this.fRequest == null || !(this.fObject instanceof IDiagramModelContainer)) {
            return;
        }
        IDiagramModelContainer container = (IDiagramModelContainer)this.fObject;
        if (container.getChildren().isEmpty()) {
            return;
        }
        if ((this.fRequest.getResizeDirection() & 1) == 0 && (this.fRequest.getResizeDirection() & 8) == 0) {
            return;
        }
        HashMap<IDiagramModelObject, IBounds> map = new HashMap<IDiagramModelObject, IBounds>();
        for (IDiagramModelObject iDiagramModelObject : container.getChildren()) {
            map.put(iDiagramModelObject, iDiagramModelObject.getBounds().getCopy());
        }
        if ((this.fRequest.getResizeDirection() & 1) != 0 && (n2 = this.fOldPos.getY() - this.fNewPos.getY()) != 0) {
            int topOffset = 0;
            for (Map.Entry dmo : map.entrySet()) {
                topOffset = Math.min(topOffset, ((IBounds)dmo.getValue()).getY() + n2);
            }
            for (Map.Entry dmo : map.entrySet()) {
                newbounds = (IBounds)dmo.getValue();
                newbounds.setY(newbounds.getY() + n2 - topOffset);
            }
        }
        if ((this.fRequest.getResizeDirection() & 8) != 0 && (n = this.fOldPos.getX() - this.fNewPos.getX()) != 0) {
            int leftOffset = 0;
            for (Map.Entry dmo : map.entrySet()) {
                leftOffset = Math.min(leftOffset, ((IBounds)dmo.getValue()).getX() + n);
            }
            for (Map.Entry dmo : map.entrySet()) {
                newbounds = (IBounds)dmo.getValue();
                newbounds.setX(newbounds.getX() + n - leftOffset);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.add((Command)new SetConstraintObjectCommand((IDiagramModelObject)entry.getKey(), (IBounds)entry.getValue()));
        }
    }

    public void dispose() {
        this.fObject = null;
        this.fNewPos = null;
        this.fOldPos = null;
        this.fRequest = null;
    }
}

