/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.dnd;

import com.archimatetool.editor.diagram.dnd.DiagramDropRequest;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModel;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class AbstractDiagramTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public AbstractDiagramTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)LocalSelectionTransfer.getTransfer());
    }

    protected void updateTargetRequest() {
        this.getNativeDropRequest().setData(this.getCurrentEvent().data);
        this.getNativeDropRequest().setDropLocation(this.getDropLocation());
    }

    protected Request createTargetRequest() {
        return new DiagramDropRequest((Transfer)LocalSelectionTransfer.getTransfer());
    }

    protected DiagramDropRequest getNativeDropRequest() {
        return (DiagramDropRequest)this.getTargetRequest();
    }

    public boolean isEnabled(DropTargetEvent event) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            if (!this.isSelectionFromSameModel((IStructuredSelection)selection)) {
                return false;
            }
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.isEnabled(object)) {
                    return super.isEnabled(event);
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean isEnabled(Object element) {
        return true;
    }

    protected IDiagramModel getTargetDiagramModel() {
        return (IDiagramModel)this.getViewer().getContents().getModel();
    }

    protected boolean isSelectionFromSameModel(IStructuredSelection selection) {
        IArchimateModel targetArchimateModel = this.getTargetDiagramModel().getArchimateModel();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArchimateModel sourceArchimateModel;
            Object object = objectArray[n2];
            if (object instanceof IArchimateModelObject && ((sourceArchimateModel = ((IArchimateModelObject)object).getArchimateModel()) == null || sourceArchimateModel != targetArchimateModel)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOver();
    }
}

