/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.diagram.editparts.AbstractFilteredEditPart;
import com.archimatetool.editor.diagram.editparts.DiagramConnectionEditPart;
import com.archimatetool.editor.diagram.figures.IDiagramModelObjectFigure;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractBaseEditPart
extends AbstractFilteredEditPart {
    protected Class<?> figureClass;

    protected AbstractBaseEditPart() {
    }

    protected AbstractBaseEditPart(Class<?> figureClass) {
        assert (IDiagramModelObjectFigure.class.isAssignableFrom(figureClass));
        this.figureClass = figureClass;
    }

    protected IFigure createFigure() {
        IDiagramModelObjectFigure figure = null;
        if (this.figureClass != null) {
            try {
                figure = (IDiagramModelObjectFigure)this.figureClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                figure.setDiagramModelObject(this.getModel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return figure;
    }

    public IDiagramModelObject getModel() {
        return (IDiagramModelObject)super.getModel();
    }

    public IDiagramModelObjectFigure getFigure() {
        return (IDiagramModelObjectFigure)super.getFigure();
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("defaultViewFont".equals(event.getProperty()) || event.getProperty().startsWith("defaultFillColour_") || event.getProperty().equals("defaultElementLineColor") || event.getProperty().equals("fontScaling")) {
            this.refreshFigure();
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getFigure().dispose();
        }
    }

    protected void refreshVisuals() {
        this.refreshBounds();
        this.refreshFigure();
    }

    public void updateEditPolicies() {
    }

    protected void refreshBounds() {
        GraphicalEditPart parentEditPart = (GraphicalEditPart)this.getParent();
        IDiagramModelObject object = this.getModel();
        Rectangle bounds = new Rectangle(object.getBounds().getX(), object.getBounds().getY(), object.getBounds().getWidth(), object.getBounds().getHeight());
        if (parentEditPart.getFigure().getLayoutManager() instanceof XYLayout) {
            parentEditPart.setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        } else if (parentEditPart.getContentPane().getLayoutManager() instanceof XYLayout) {
            parentEditPart.getContentPane().setConstraint((IFigure)this.getFigure(), (Object)bounds);
        }
    }

    protected void refreshFigure() {
    }

    protected void refreshChildrenFigures() {
        this.refreshFigure();
        for (Object editPart : this.getSourceConnections()) {
            if (!(editPart instanceof DiagramConnectionEditPart)) continue;
            ((DiagramConnectionEditPart)((Object)editPart)).refreshVisuals();
        }
        for (Object editPart : this.getChildren()) {
            if (!(editPart instanceof AbstractBaseEditPart)) continue;
            ((AbstractBaseEditPart)((Object)editPart)).refreshChildrenFigures();
        }
    }

    public boolean isLocked() {
        return this.getModel() instanceof ILockable && ((ILockable)this.getModel()).isLocked();
    }

    protected void showPropertiesView() {
        ViewManager.showViewPart(ViewManager.PROPERTIES_VIEW, false);
    }

    public DragTracker getDragTracker(Request request) {
        return this.isLocked() ? new SelectEditPartTracker((EditPart)this) : super.getDragTracker(request);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.getModel() != null && adapter.isInstance(this.getModel())) {
            return adapter.cast(this.getModel());
        }
        return (T)super.getAdapter(adapter);
    }
}

