/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.editparts.AbstractBaseEditPart;
import com.archimatetool.editor.diagram.editparts.AbstractDiagramPart;
import com.archimatetool.editor.diagram.editparts.IConnectionEditPartFilter;
import com.archimatetool.editor.diagram.editparts.OrthogonalAnchor;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractConnectedEditPart
extends AbstractBaseEditPart
implements NodeEditPart {
    private Adapter adapter = new LightweightEContentAdapter(this::eCoreChanged, new Class[]{IFeature.class});

    protected AbstractConnectedEditPart() {
    }

    protected AbstractConnectedEditPart(Class<?> figureClass) {
        super(figureClass);
    }

    protected void eCoreChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (IFeatures.isFeatureNotification((Notification)msg)) {
            this.refreshFigure();
            return;
        }
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.refreshSourceConnections();
                this.refreshTargetConnections();
                this.refreshChildren();
                break;
            }
            case 1: {
                if (feature == IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__BOUNDS) {
                    this.refreshBounds();
                } else if (feature == IArchimatePackage.Literals.LOCKABLE__LOCKED) {
                    this.updateEditPolicies();
                    EditPart editPart = this.getParent();
                    if (editPart instanceof AbstractDiagramPart) {
                        AbstractDiagramPart part = (AbstractDiagramPart)editPart;
                        part.updateEditPolicies();
                    } else {
                        EditPart editPart2 = this.getParent();
                        if (editPart2 instanceof AbstractBaseEditPart) {
                            AbstractBaseEditPart part = (AbstractBaseEditPart)editPart2;
                            part.updateEditPolicies();
                        }
                    }
                } else {
                    this.refreshFigure();
                }
                if (feature != IArchimatePackage.Literals.BORDER_TYPE__BORDER_TYPE || msg.getNotifier() != this.getModel()) break;
                this.refreshConnectionAnchors();
                break;
            }
        }
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("hiddenRelationsTypes".equals(event.getProperty()) || "useNestedConnections".equals(event.getProperty())) {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        } else if ("orthogonalAnchor".equals(event.getProperty())) {
            this.refreshConnectionAnchors();
        }
        super.applicationPreferencesChanged(event);
    }

    @Override
    protected Adapter getECoreAdapter() {
        return this.adapter;
    }

    public void refreshSourceConnections() {
        super.refreshSourceConnections();
    }

    public void refreshTargetConnections() {
        super.refreshTargetConnections();
    }

    protected List<IDiagramModelConnection> getModelSourceConnections() {
        return this.getFilteredModelSourceConnections();
    }

    protected List<IDiagramModelConnection> getModelTargetConnections() {
        return this.getFilteredModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.canUseOrthogonalAnchor() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("orthogonalAnchor")) {
            return new OrthogonalAnchor((IFigure)this.getFigure(), connection, true);
        }
        return this.getDefaultConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.canUseOrthogonalAnchor() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("orthogonalAnchor")) {
            return new OrthogonalAnchor((IFigure)this.getFigure(), connection, false);
        }
        return this.getDefaultConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.canUseOrthogonalAnchor() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("orthogonalAnchor")) {
            return new OrthogonalAnchor((IFigure)this.getFigure(), request, true);
        }
        return this.getDefaultConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (this.canUseOrthogonalAnchor() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("orthogonalAnchor")) {
            return new OrthogonalAnchor((IFigure)this.getFigure(), request, false);
        }
        return this.getDefaultConnectionAnchor();
    }

    protected boolean canUseOrthogonalAnchor() {
        return true;
    }

    protected ConnectionAnchor getDefaultConnectionAnchor() {
        return this.getFigure().getDefaultConnectionAnchor();
    }

    protected void refreshConnectionAnchors() {
        for (Object editPart : this.getSourceConnections()) {
            ((EditPart)editPart).refresh();
        }
        for (Object editPart : this.getTargetConnections()) {
            ((EditPart)editPart).refresh();
        }
    }

    public List<IDiagramModelConnection> getFilteredModelSourceConnections() {
        return this.getFilteredConnections((List<IDiagramModelConnection>)this.getModel().getSourceConnections());
    }

    public List<IDiagramModelConnection> getFilteredModelTargetConnections() {
        return this.getFilteredConnections((List<IDiagramModelConnection>)this.getModel().getTargetConnections());
    }

    private List<IDiagramModelConnection> getFilteredConnections(List<IDiagramModelConnection> originalList) {
        IConnectionEditPartFilter[] filters = this.getRootEditPartFilterProvider().getEditPartFilters(IConnectionEditPartFilter.class);
        if (filters != null) {
            ArrayList<IDiagramModelConnection> filteredList = new ArrayList<IDiagramModelConnection>();
            for (IDiagramModelConnection connection : originalList) {
                boolean add = true;
                IConnectionEditPartFilter[] iConnectionEditPartFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionEditPartFilter filter = iConnectionEditPartFilterArray[n2];
                    add = filter.isConnectionVisible((EditPart)this, connection);
                    if (!add) break;
                    ++n2;
                }
                if (!add) continue;
                filteredList.add(connection);
            }
            return filteredList;
        }
        return originalList;
    }
}

