/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.editparts;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.editparts.AbstractBaseEditPart;
import com.archimatetool.editor.diagram.editparts.AbstractFilteredEditPart;
import com.archimatetool.editor.diagram.editparts.IEditPartFilter;
import com.archimatetool.editor.diagram.editparts.IEditPartFilterProvider;
import com.archimatetool.editor.diagram.editparts.NestedConnectionEditPartFilter;
import com.archimatetool.editor.diagram.editparts.SnapEditPartAdapter;
import com.archimatetool.editor.diagram.util.AnimationUtil;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.util.LightweightEContentAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractDiagramPart
extends AbstractFilteredEditPart
implements IEditPartFilterProvider {
    private List<IEditPartFilter> fEditPartFilters;
    private Adapter adapter = new LightweightEContentAdapter(this::eCoreChanged, new Class[]{IFeature.class});

    protected AbstractDiagramPart() {
        this.addEditPartFilter(new NestedConnectionEditPartFilter());
    }

    protected void eCoreChanged(Notification msg) {
        Object feature = msg.getFeature();
        if (IFeatures.isFeatureNotification((Notification)msg)) {
            this.refreshVisuals();
            return;
        }
        switch (msg.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.refreshChildren();
                break;
            }
            case 1: {
                if (feature != IArchimatePackage.Literals.DIAGRAM_MODEL__CONNECTION_ROUTER_TYPE) break;
                this.setConnectionRouter(true);
                break;
            }
        }
    }

    @Override
    protected Adapter getECoreAdapter() {
        return this.adapter;
    }

    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if (event.getProperty() == "antiAlias") {
            this.setAntiAlias();
            this.refresh();
        }
    }

    protected void refreshChildrenFigures() {
        for (Object editPart : this.getChildren()) {
            if (!(editPart instanceof AbstractBaseEditPart)) continue;
            ((AbstractBaseEditPart)((Object)editPart)).refreshChildrenFigures();
        }
    }

    public IDiagramModel getModel() {
        return (IDiagramModel)super.getModel();
    }

    @Override
    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        if (this.fEditPartFilters != null) {
            this.fEditPartFilters.clear();
            this.fEditPartFilters = null;
        }
    }

    public void updateEditPolicies() {
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        int marginWidth = ArchiPlugin.getInstance().getPreferenceStore().getInt("marginWidth");
        figure.setBorder((Border)new MarginBorder(marginWidth));
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        AnimationUtil.addFigureForAnimation((IFigure)figure);
        this.setAntiAlias();
        return figure;
    }

    public void refreshVisuals() {
        this.setConnectionRouter(false);
    }

    protected void setConnectionRouter(boolean withAnimation) {
        if (withAnimation && AnimationUtil.doAnimate()) {
            Animation.markBegin();
        }
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        switch (this.getModel().getConnectionRouterType()) {
            case 2: {
                cLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                FanRouter router = new FanRouter();
                router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
                cLayer.setConnectionRouter((ConnectionRouter)router);
            }
        }
        if (withAnimation && AnimationUtil.doAnimate()) {
            Animation.run((int)AnimationUtil.animationSpeed());
        }
    }

    protected void setAntiAlias() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        cLayer.setAntialias(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("antiAlias") ? 1 : -1);
    }

    public boolean isSelectable() {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == SnapToHelper.class) {
            return adapter.cast(new SnapEditPartAdapter((GraphicalEditPart)this).getSnapToHelper());
        }
        if (this.getModel() != null && adapter.isInstance(this.getModel())) {
            return adapter.cast(this.getModel());
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public void addEditPartFilter(IEditPartFilter filter) {
        if (this.fEditPartFilters == null) {
            this.fEditPartFilters = new ArrayList<IEditPartFilter>();
        }
        this.fEditPartFilters.add(filter);
    }

    @Override
    public void removeEditPartFilter(IEditPartFilter filter) {
        if (this.fEditPartFilters != null && filter != null) {
            this.fEditPartFilters.remove(filter);
            if (this.fEditPartFilters.isEmpty()) {
                this.fEditPartFilters = null;
            }
        }
    }

    @Override
    public IEditPartFilter[] getEditPartFilters() {
        if (this.fEditPartFilters == null) {
            return null;
        }
        IEditPartFilter[] result = new IEditPartFilter[this.fEditPartFilters.size()];
        this.fEditPartFilters.toArray(result);
        return result;
    }

    @Override
    public <T> T[] getEditPartFilters(Class<T> T) {
        if (this.fEditPartFilters == null) {
            return null;
        }
        ArrayList<IEditPartFilter> filteredList = new ArrayList<IEditPartFilter>();
        for (IEditPartFilter filter : this.fEditPartFilters) {
            if (!T.isInstance(filter)) continue;
            filteredList.add(filter);
        }
        if (filteredList.isEmpty()) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(T, filteredList.size());
        return filteredList.toArray(result);
    }
}

